/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.tree;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.eclipse.scout.rt.ui.swing.basic.AbstractHtmlLinkDetector;

public class TreeHtmlLinkDetector
extends AbstractHtmlLinkDetector<JTree> {
    private TreePath m_treePath;

    @Override
    public boolean detect(JTree container, Point p) {
        boolean found = super.detect(container, p);
        this.m_treePath = found ? this.getPath(p) : null;
        return found;
    }

    public TreePath getTreePath() {
        return this.m_treePath;
    }

    @Override
    protected Rectangle getCellRectangle(Point p) {
        return ((JTree)this.getContainer()).getPathBounds(this.getPath(p));
    }

    @Override
    protected Component getComponent(Point p) {
        JTree tree = (JTree)this.getContainer();
        TreePath path = this.getPath(p);
        if (path != null) {
            TreeCellRenderer renderer = ((JTree)this.getContainer()).getCellRenderer();
            return renderer.getTreeCellRendererComponent(tree, path.getLastPathComponent(), tree.isPathSelected(path), tree.isExpanded(path), tree.getModel().isLeaf(path.getLastPathComponent()), tree.getRowForPath(path), true);
        }
        return null;
    }

    private TreePath getPath(Point p) {
        return ((JTree)this.getContainer()).getPathForLocation(p.x, p.y);
    }
}

