/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class JToggleButtonEx
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    private Color m_enabledBackgroundColor;
    private Color m_disabledBackgroundColor;

    public JToggleButtonEx() {
        this((Action)null);
    }

    public JToggleButtonEx(Action a) {
        if (a != null) {
            this.setAction(a);
        }
        SwingUtility.installDefaultFocusHandling(this);
    }

    @Override
    public void setBackground(Color bg) {
        Color cc;
        this.m_enabledBackgroundColor = bg;
        this.m_disabledBackgroundColor = null;
        if (bg != null && (cc = UIManager.getColor("control")) != null) {
            this.m_disabledBackgroundColor = new ColorUIResource(new Color((bg.getRed() + cc.getRed()) / 2, (bg.getGreen() + cc.getGreen()) / 2, (bg.getBlue() + cc.getBlue()) / 2));
        }
        super.setBackground(bg);
    }

    @Override
    public void setEnabled(boolean b) {
        boolean changed = this.isEnabled() ^ b;
        super.setEnabled(b);
        if (changed) {
            if (b) {
                if (this.m_enabledBackgroundColor != null) {
                    super.setBackground(this.m_enabledBackgroundColor);
                }
            } else if (this.m_disabledBackgroundColor != null) {
                super.setBackground(this.m_disabledBackgroundColor);
            }
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }
}

