/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.internal;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class GridLayoutCanvas
extends JPanel {
    private static final long serialVersionUID = 1L;
    public final List<Line> m_lines = new ArrayList<Line>();
    public final List<Bounds> m_bounds = new ArrayList<Bounds>();

    public GridLayoutCanvas() {
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color bForegroud;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setComposite(AlphaComposite.SrcOver.derive(0.35f));
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (Bounds b : this.m_bounds) {
            bForegroud = g2d.getColor();
            try {
                if (b.color != null) {
                    g2d.setColor(b.color);
                }
                g2d.drawRect(b.bounds.x, b.bounds.y, b.bounds.width, b.bounds.height);
            }
            finally {
                g2d.setColor(bForegroud);
            }
        }
        for (Line l : this.m_lines) {
            bForegroud = g2d.getColor();
            try {
                if (l.color != null) {
                    g2d.setColor(l.color);
                }
                g2d.drawLine(l.start.x, l.start.y, l.end.x, l.end.y);
            }
            finally {
                g2d.setColor(bForegroud);
            }
        }
    }

    public void addBounds(Bounds bounds) {
        this.m_bounds.add(bounds);
        this.repaint();
    }

    public void addLine(Line line) {
        this.m_lines.add(line);
        this.repaint();
    }

    public static class Bounds {
        public Rectangle bounds;
        public Color color;

        public Bounds(Rectangle bounds, Color color) {
            this.bounds = bounds;
            this.color = color;
        }
    }

    public static class Line {
        public Point start;
        public Point end;
        public Color color;

        public Line(Point start, Point end, Color color) {
            this.start = start;
            this.end = end;
            this.color = color;
        }
    }
}

