/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields;

import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.form.fields.IBasicField;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;

public abstract class SwingScoutBasicFieldComposite<T extends IBasicField<?>>
extends SwingScoutValueFieldComposite<T> {
    private boolean m_validateOnAnyKey;

    @Override
    protected void attachScout() {
        IBasicField f = (IBasicField)this.getScoutObject();
        this.setValidateOnAnyKeyFromScout(f.isValidateOnAnyKey());
        super.attachScout();
    }

    @Override
    public JTextComponent getSwingField() {
        return (JTextComponent)super.getSwingField();
    }

    protected void addInputListenersForBasicField(JTextComponent textField, Document doc) {
        doc.addDocumentListener(new P_SwingDocumentListener());
        textField.addCaretListener(new P_SwingCaretListener());
    }

    protected void setValidateOnAnyKeyFromScout(boolean b) {
        this.m_validateOnAnyKey = b;
    }

    @Override
    protected void setDisplayTextFromScout(String newText) {
        JTextComponent swingField = this.getSwingField();
        String oldText = swingField.getText();
        if (newText == null) {
            newText = "";
        }
        if (oldText == null) {
            oldText = "";
        }
        if (oldText.equals(newText)) {
            return;
        }
        try {
            this.getUpdateSwingFromScoutLock().acquire();
            int startIndex = -1;
            int endIndex = -1;
            Caret caret = swingField.getCaret();
            if (caret != null) {
                startIndex = caret.getMark();
                endIndex = caret.getDot();
            }
            if (startIndex == endIndex && newText.length() != oldText.length()) {
                if (startIndex >= oldText.length()) {
                    startIndex = newText.length();
                } else if (newText.endsWith(oldText.substring(startIndex))) {
                    startIndex = newText.length() - oldText.substring(startIndex).length();
                }
                endIndex = startIndex;
            }
            swingField.setText(newText);
            int textLength = swingField.getText().length();
            if (caret != null) {
                startIndex = Math.min(Math.max(startIndex, -1), textLength);
                endIndex = Math.min(Math.max(endIndex, 0), textLength);
                swingField.setCaretPosition(startIndex);
                swingField.moveCaretPosition(endIndex);
            }
        }
        finally {
            this.getUpdateSwingFromScoutLock().release();
        }
    }

    protected abstract void setSelectionFromSwing();

    protected abstract boolean isSelectAllOnFocusInScout();

    @Override
    protected boolean handleSwingInputVerifier() {
        final String text = this.getSwingField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IBasicField)this.getScoutObject()).getDisplayText()) && ((IBasicField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IBasicField)SwingScoutBasicFieldComposite.this.getScoutObject()).getUIFacade().setTextFromUI(text, false);
            }
        };
        JobEx job = this.getSwingEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getSwingEnvironment().dispatchImmediateSwingJobs();
        if (!this.m_validateOnAnyKey) {
            this.setSelectionFromSwing();
        }
        return true;
    }

    @Override
    protected void handleSwingFocusGained() {
        super.handleSwingFocusGained();
        JTextComponent swingField = this.getSwingField();
        if (!this.isMenuOpened() && this.isSelectAllOnFocusInScout() && swingField.getDocument().getLength() > 0) {
            swingField.setCaretPosition(swingField.getDocument().getLength());
            swingField.moveCaretPosition(0);
        }
        this.setMenuOpened(false);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("validateOnAnyKey")) {
            this.setValidateOnAnyKeyFromScout((Boolean)newValue);
        }
    }

    private class P_SwingCaretListener
    implements CaretListener {
        private P_SwingCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (SwingScoutBasicFieldComposite.this.m_validateOnAnyKey) {
                SwingScoutBasicFieldComposite.this.setSelectionFromSwing();
            }
        }
    }

    private class P_SwingDocumentListener
    implements DocumentListener {
        private P_SwingDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SwingScoutBasicFieldComposite.this.setInputDirty(true);
            if (SwingScoutBasicFieldComposite.this.m_validateOnAnyKey && SwingScoutBasicFieldComposite.this.getUpdateSwingFromScoutLock().isReleased()) {
                this.sendVerifyToScoutAndIgnoreResponses();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SwingScoutBasicFieldComposite.this.setInputDirty(true);
            if (SwingScoutBasicFieldComposite.this.m_validateOnAnyKey && SwingScoutBasicFieldComposite.this.getUpdateSwingFromScoutLock().isReleased()) {
                this.sendVerifyToScoutAndIgnoreResponses();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SwingScoutBasicFieldComposite.this.setInputDirty(true);
            if (SwingScoutBasicFieldComposite.this.m_validateOnAnyKey && SwingScoutBasicFieldComposite.this.getUpdateSwingFromScoutLock().isReleased()) {
                this.sendVerifyToScoutAndIgnoreResponses();
            }
        }

        private void sendVerifyToScoutAndIgnoreResponses() {
            final String text = SwingScoutBasicFieldComposite.this.getSwingField().getText();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IBasicField)SwingScoutBasicFieldComposite.this.getScoutObject()).getUIFacade().setTextFromUI(text, true);
                }
            };
            SwingScoutBasicFieldComposite.this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }
}

