/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.ext.JRootPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextAreaEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldEx;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;

public abstract class SwingScoutFieldComposite<T extends IFormField>
extends SwingScoutComposite<T>
implements ISwingScoutFormField<T> {
    public static final String CLIENT_PROP_INITIAL_LABEL_OPAQUE = "scoutInitialLabelOpaque";
    public static final String CLIENT_PROP_INITIAL_LABEL_FONT = "scoutInitialLabelFont";
    public static final String CLIENT_PROP_INITIAL_LABEL_BACKGROUND = "scoutInitialLabelBackground";
    public static final String CLIENT_PROP_INITIAL_LABEL_FOREGROUND = "scoutInitialLabelForeground";
    private JComponent m_swingContainer;
    private JStatusLabelEx m_swingStatusLabel;
    private List<IKeyStroke> m_installedScoutKs;

    @Override
    public JComponent getSwingContainer() {
        return this.m_swingContainer;
    }

    protected void setSwingContainer(JComponent swingContainer) {
        this.m_swingContainer = swingContainer;
    }

    @Override
    public JStatusLabelEx getSwingLabel() {
        return this.m_swingStatusLabel;
    }

    @Override
    protected void cacheSwingClientProperties() {
        super.cacheSwingClientProperties();
        JStatusLabelEx fld = this.getSwingLabel();
        if (fld != null) {
            if (!this.existsClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_OPAQUE)) {
                this.putClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_OPAQUE, new Boolean(fld.isOpaque()));
            }
            if (!this.existsClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_BACKGROUND)) {
                this.putClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_BACKGROUND, fld.getBackground());
            }
            if (!this.existsClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_FOREGROUND)) {
                this.putClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_FOREGROUND, fld.getForeground());
            }
            if (!this.existsClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_FONT)) {
                this.putClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_FONT, fld.getFont());
            }
        }
    }

    protected void setSwingLabel(JStatusLabelEx swingLabel) {
        this.m_swingStatusLabel = swingLabel;
        if (this.m_swingStatusLabel != null) {
            LogicalGridData statusLabelGridData = null;
            if (((IFormField)this.getScoutObject()).getLabelPosition() == 4) {
                this.m_swingStatusLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
                statusLabelGridData = LogicalGridDataBuilder.createLabelOnTop(((IFormField)this.getScoutObject()).getGridData());
            } else {
                statusLabelGridData = LogicalGridDataBuilder.createLabel(this.getSwingEnvironment(), ((IFormField)this.getScoutObject()).getGridData());
            }
            this.m_swingStatusLabel.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, statusLabelGridData);
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IFormField scoutField = (IFormField)this.getScoutObject();
        if (scoutField != null) {
            this.setVisibleFromScout(scoutField.isVisible());
            this.setLabelWidthInPixelFromScout();
            this.setLabelHorizontalAlignmentFromScout();
            this.setEnabledFromScout(scoutField.isEnabled());
            this.setLabelBackgroundFromScout(scoutField.getLabelBackgroundColor());
            this.setLabelForegroundFromScout(scoutField.getLabelForegroundColor());
            this.setLabelFontFromScout(scoutField.getLabelFont());
            if (!(scoutField instanceof ISequenceBox)) {
                this.setMandatoryFromScout(scoutField.isMandatory());
            }
            this.setErrorStatusFromScout(scoutField.getErrorStatus());
            this.setLabelFromScout(scoutField.getLabel());
            this.setLabelVisibleFromScout();
            this.setTooltipTextFromScout(scoutField.getTooltipText());
            if (((IFormField)this.getScoutObject()).getLabelPosition() == 2 && scoutField.getLabel() != null && scoutField.getTooltipText() == null) {
                this.setTooltipTextFromScout(scoutField.getLabel());
            }
            this.setBackgroundFromScout(scoutField.getBackgroundColor());
            this.setForegroundFromScout(scoutField.getForegroundColor());
            this.setFontFromScout(scoutField.getFont());
            this.setSaveNeededFromScout(scoutField.isSaveNeeded());
            this.setEmptyFromScout(scoutField.isEmpty());
            this.setFocusableFromScout(scoutField.isFocusable());
            this.setHorizontalAlignmentFromScout(scoutField.getGridData().horizontalAlignment);
            this.setVerticalAlignmentFromScout(scoutField.getGridData().verticalAlignment);
            this.setKeyStrokesFromScout();
        }
    }

    protected void setVisibleFromScout(boolean b) {
        JRootPaneEx rp;
        JComponent changedComponent = null;
        if (this.m_swingContainer != null) {
            if (this.m_swingContainer.isVisible() != b) {
                this.m_swingContainer.setVisible(b);
                changedComponent = this.m_swingContainer;
            }
        } else if (this.getSwingField() != null && this.getSwingField().isVisible() != b) {
            this.getSwingField().setVisible(b);
            changedComponent = this.getSwingField();
        }
        if (changedComponent != null && (rp = (JRootPaneEx)SwingUtilities.getAncestorOfClass(JRootPaneEx.class, changedComponent)) != null) {
            rp.notifyVisibleChanged(changedComponent);
        }
    }

    protected void setEnabledFromScout(boolean b) {
        if (this.getSwingField() instanceof JTextComponent) {
            JTextComponent c = (JTextComponent)this.getSwingField();
            c.setEditable(b);
        } else if (this.getSwingField() != null) {
            this.getSwingField().setEnabled(b);
        }
        if (this.getSwingLabel() != null) {
            this.getSwingLabel().setEnabled(b);
        }
    }

    protected void setMandatoryFromScout(boolean b) {
        if (this.getSwingLabel() != null) {
            this.getSwingLabel().setMandatory(b);
        }
    }

    protected void setErrorStatusFromScout(IProcessingStatus s) {
        if (this.getSwingLabel() != null) {
            this.getSwingLabel().setStatus(s);
        }
    }

    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
    }

    protected void setVerticalAlignmentFromScout(int scoutAlign) {
    }

    protected void setLabelVisibleFromScout() {
        if (this.m_swingStatusLabel == null) {
            return;
        }
        boolean b = ((IFormField)this.getScoutObject()).isLabelVisible();
        if (((IFormField)this.getScoutObject()).getLabelPosition() == 2) {
            this.m_swingStatusLabel.setText(null);
            this.m_swingStatusLabel.setLayoutWidthHint(0);
        }
        this.m_swingStatusLabel.setVisible(b);
        if (this.m_swingContainer != null) {
            this.m_swingContainer.revalidate();
        }
    }

    protected void setLabelFromScout(String s) {
        if (this.m_swingStatusLabel != null) {
            if (((IFormField)this.getScoutObject()).getLabelPosition() == 2) {
                this.m_swingStatusLabel.setText(null);
            } else {
                this.m_swingStatusLabel.setText(s);
            }
            if (this.m_swingContainer != null && this.m_swingStatusLabel.isVisible()) {
                this.m_swingContainer.revalidate();
            }
        }
        if (this.getSwingField() instanceof JTextFieldEx) {
            JTextFieldEx tf = (JTextFieldEx)this.getSwingField();
            if (((IFormField)this.getScoutObject()).getLabelPosition() == 2) {
                if (tf.getOnFieldLabelHandler() == null) {
                    tf.setOnFieldLabelHandler(this.getSwingEnvironment().createOnFieldLabelDecorator(tf, ((IFormField)this.getScoutObject()).isMandatory()));
                }
                tf.getOnFieldLabelHandler().setLabel(s);
            } else {
                tf.setOnFieldLabelHandler(null);
            }
        } else if (this.getSwingField() instanceof JTextAreaEx) {
            JTextAreaEx taf = (JTextAreaEx)this.getSwingField();
            if (((IFormField)this.getScoutObject()).getLabelPosition() == 2) {
                if (taf.getOnFieldLabelHandler() == null) {
                    taf.setOnFieldLabelHandler(this.getSwingEnvironment().createOnFieldLabelDecorator(taf, ((IFormField)this.getScoutObject()).isMandatory()));
                }
                taf.getOnFieldLabelHandler().setLabel(s);
            } else {
                taf.setOnFieldLabelHandler(null);
            }
        }
    }

    protected void setLabelWidthInPixelFromScout() {
        if (this.getSwingLabel() != null) {
            int w = ((IFormField)this.getScoutObject()).getLabelWidthInPixel();
            if (w > 0) {
                this.getSwingLabel().setLayoutWidthHint(w);
            } else if (w == 0) {
                this.getSwingLabel().setLayoutWidthHint(this.getSwingEnvironment().getFieldLabelWidth());
            } else if (w == -1) {
                this.getSwingLabel().setLayoutWidthHint(0);
            }
        }
    }

    protected void setLabelHorizontalAlignmentFromScout() {
        if (this.getSwingLabel() != null) {
            int swingAlign = SwingUtility.createHorizontalAlignment(((IFormField)this.getScoutObject()).getLabelHorizontalAlignment());
            this.getSwingLabel().setLayoutHorizontalAlignment(swingAlign);
        }
    }

    protected void setTooltipTextFromScout(String s) {
        s = SwingUtility.createHtmlLabelText(s, true);
        if (this.getSwingField() != null) {
            this.getSwingField().setToolTipText(s);
        }
    }

    protected void setBackgroundFromScout(String scoutColor) {
        JComponent fld = this.getSwingField();
        if (fld != null) {
            boolean opaque;
            Color initCol = (Color)this.getClientProperty(fld, "scoutInitialBackground");
            boolean initOpaque = (Boolean)this.getClientProperty(fld, "scoutInitialOpaque");
            Color c = ColorUtility.createColor(scoutColor);
            boolean bl = opaque = c != null ? true : initOpaque;
            if (c == null) {
                c = initCol;
            }
            fld.setOpaque(opaque);
            fld.setBackground(c);
        }
    }

    protected void setForegroundFromScout(String scoutColor) {
        JComponent fld = this.getSwingField();
        if (fld != null) {
            Color initCol = (Color)this.getClientProperty(fld, "scoutInitialForeground");
            Color c = ColorUtility.createColor(scoutColor);
            if (c == null) {
                c = initCol;
            }
            fld.setForeground(c);
        }
    }

    protected void setFontFromScout(FontSpec scoutFont) {
        JComponent fld = this.getSwingField();
        if (fld != null) {
            Font initFont = (Font)this.getClientProperty(fld, "scoutInitialFont");
            Font f = SwingUtility.createFont(scoutFont, initFont);
            if (f == null) {
                f = initFont;
            }
            fld.setFont(f);
        }
    }

    protected void setLabelBackgroundFromScout(String scoutColor) {
        JStatusLabelEx fld = this.getSwingLabel();
        if (fld != null) {
            boolean opaque;
            Color initCol = (Color)this.getClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_BACKGROUND);
            boolean initOpaque = (Boolean)this.getClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_OPAQUE);
            Color c = ColorUtility.createColor(scoutColor);
            boolean bl = opaque = c != null ? true : initOpaque;
            if (c == null) {
                c = initCol;
            }
            fld.setOpaque(opaque);
            ((JComponent)fld).setBackground(c);
        }
    }

    protected void setLabelForegroundFromScout(String scoutColor) {
        JStatusLabelEx fld = this.getSwingLabel();
        if (fld != null) {
            Color initCol = (Color)this.getClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_FOREGROUND);
            Color c = ColorUtility.createColor(scoutColor);
            if (c == null) {
                c = initCol;
            }
            ((JComponent)fld).setForeground(c);
        }
    }

    protected void setLabelFontFromScout(FontSpec scoutFont) {
        JStatusLabelEx fld = this.getSwingLabel();
        if (fld != null) {
            Font initFont = (Font)this.getClientProperty(fld, CLIENT_PROP_INITIAL_LABEL_FONT);
            Font f = SwingUtility.createFont(scoutFont, initFont);
            if (f == null) {
                f = initFont;
            }
            ((JComponent)fld).setFont(f);
        }
    }

    protected void setSaveNeededFromScout(boolean b) {
    }

    protected void setEmptyFromScout(boolean b) {
    }

    protected void setFocusableFromScout(boolean b) {
        if (this.getSwingField() != null) {
            this.getSwingField().setFocusable(b);
        }
    }

    protected void setKeyStrokesFromScout() {
        JComponent component = this.getSwingContainer();
        if (component == null) {
            component = this.getSwingField();
        }
        if (component != null) {
            if (this.m_installedScoutKs != null) {
                for (IKeyStroke scoutKs : this.m_installedScoutKs) {
                    KeyStroke swingKs = SwingUtility.createKeystroke(scoutKs);
                    InputMap imap = component.getInputMap(1);
                    imap.remove(swingKs);
                    ActionMap amap = component.getActionMap();
                    amap.remove(scoutKs.getActionId());
                }
            }
            this.m_installedScoutKs = null;
            List scoutKeyStrokes = ((IFormField)this.getScoutObject()).getKeyStrokes();
            for (IKeyStroke scoutKs : scoutKeyStrokes) {
                int swingWhen = 1;
                KeyStroke swingKs = SwingUtility.createKeystroke(scoutKs);
                SwingScoutAction<IKeyStroke> action = new SwingScoutAction<IKeyStroke>();
                action.createField(scoutKs, this.getSwingEnvironment());
                InputMap imap = component.getInputMap(swingWhen);
                imap.put(swingKs, scoutKs.getActionId());
                ActionMap amap = component.getActionMap();
                amap.put(scoutKs.getActionId(), action.getSwingAction());
            }
            this.m_installedScoutKs = scoutKeyStrokes;
        }
    }

    @Override
    protected boolean isHandleScoutPropertyChange(final String name, final Object newValue) {
        if (name.equals("enabled") || name.equals("visible")) {
            this.getSwingEnvironment().postImmediateSwingJob(new Runnable(){

                @Override
                public void run() {
                    SwingScoutFieldComposite.this.handleScoutPropertyChange(name, newValue);
                }
            });
        }
        return super.isHandleScoutPropertyChange(name, newValue);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("enabled")) {
            this.setEnabledFromScout((Boolean)newValue);
        } else if (name.equals("focusable")) {
            this.setFocusableFromScout((Boolean)newValue);
        } else if (name.equals("label")) {
            this.setLabelFromScout((String)newValue);
        } else if (name.equals("labelVisible")) {
            this.setLabelVisibleFromScout();
        } else if (name.equals("tooltipText")) {
            this.setTooltipTextFromScout((String)newValue);
        } else if (name.equals("visible")) {
            this.setVisibleFromScout((Boolean)newValue);
        } else if (name.equals("mandatory")) {
            this.setMandatoryFromScout((Boolean)newValue);
        } else if (name.equals("errorStatus")) {
            this.setErrorStatusFromScout((IProcessingStatus)newValue);
        } else if (name.equals("foregroundColor")) {
            this.setForegroundFromScout((String)newValue);
        } else if (name.equals("backgroundColor")) {
            this.setBackgroundFromScout((String)newValue);
        } else if (name.equals("font")) {
            this.setFontFromScout((FontSpec)newValue);
        } else if (name.equals("labelForegroundColor")) {
            this.setLabelForegroundFromScout((String)newValue);
        } else if (name.equals("labelBackgroundColor")) {
            this.setLabelBackgroundFromScout((String)newValue);
        } else if (name.equals("labelFont")) {
            this.setLabelFontFromScout((FontSpec)newValue);
        } else if (name.equals("saveNeeded")) {
            this.setSaveNeededFromScout((Boolean)newValue);
        } else if (name.equals("empty")) {
            this.setEmptyFromScout((Boolean)newValue);
        } else if (name.equals("keyStrokes")) {
            this.setKeyStrokesFromScout();
        }
    }
}

