/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.filechooserfield;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.menu.SwingScoutContextMenu;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.decoration.ContextMenuDecorationItem;
import org.eclipse.scout.rt.ui.swing.ext.decoration.DecorationGroup;
import org.eclipse.scout.rt.ui.swing.ext.decoration.DropDownDecorationItem;
import org.eclipse.scout.rt.ui.swing.ext.decoration.JTextFieldWithDecorationIcons;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.filechooserfield.ISwingScoutFileChooserField;

public class SwingScoutFileChooserField
extends SwingScoutValueFieldComposite<IFileChooserField>
implements ISwingScoutFileChooserField {
    private static final long serialVersionUID = 1L;
    private ContextMenuDecorationItem m_contextMenuMarker;
    private SwingScoutContextMenu m_contextMenu;
    private DropDownDecorationItem m_dropdownIcon;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JTextComponent textField = this.createTextField(container);
        Document doc = textField.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingScoutFileChooserField.this.setInputDirty(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingScoutFileChooserField.this.setInputDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingScoutFileChooserField.this.setInputDirty(true);
            }
        });
        InputMap inputMap = textField.getInputMap(0);
        inputMap.put(SwingUtility.createKeystroke("F2"), "fileChooser");
        ActionMap actionMap = textField.getActionMap();
        actionMap.put("fileChooser", new P_SwingFileChooserAction());
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(textField);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    protected JTextComponent createTextField(JComponent container) {
        JTextFieldWithDecorationIcons textField = new JTextFieldWithDecorationIcons();
        container.add(textField);
        DecorationGroup decorationGroup = new DecorationGroup(textField, this.getSwingEnvironment());
        this.m_contextMenuMarker = new ContextMenuDecorationItem((IContextMenu)((IFileChooserField)this.getScoutObject()).getContextMenu(), textField, this.getSwingEnvironment());
        this.m_contextMenuMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingScoutFileChooserField.this.m_contextMenu.showSwingPopup(e.getX(), e.getY(), false);
            }
        });
        decorationGroup.addDecoration(this.m_contextMenuMarker);
        this.m_dropdownIcon = new DropDownDecorationItem(textField, this.getSwingEnvironment());
        this.m_dropdownIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    SwingScoutFileChooserField.this.m_contextMenu.showSwingPopup(e.getX(), e.getY(), false);
                } else {
                    SwingScoutFileChooserField.this.getSwingTextField().requestFocus();
                    SwingScoutFileChooserField.this.handleSwingFileChooserAction();
                }
            }
        });
        decorationGroup.addDecoration(this.m_dropdownIcon);
        textField.setDecorationIcon(decorationGroup);
        return textField;
    }

    @Override
    protected void installContextMenu() {
        ((IFileChooserField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    SwingScoutFileChooserField.this.m_contextMenuMarker.setMarkerVisible(((IFileChooserField)SwingScoutFileChooserField.this.getScoutObject()).getContextMenu().isVisible());
                }
            }
        });
        this.m_contextMenuMarker.setMarkerVisible(((IFileChooserField)this.getScoutObject()).getContextMenu().isVisible());
        this.m_contextMenu = SwingScoutContextMenu.installContextMenuWithSystemMenus(this.getSwingTextField(), (IContextMenu)((IFileChooserField)this.getScoutObject()).getContextMenu(), this.getSwingEnvironment());
    }

    @Override
    public JTextComponent getSwingTextField() {
        return (JTextComponent)this.getSwingField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IFileChooserField f = (IFileChooserField)this.getScoutObject();
        this.setFileIconIdFromScout(f.getFileIconId());
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        JTextComponent swingField = this.getSwingTextField();
        swingField.setText(s);
    }

    private boolean calculateDropDownButtonEnabled() {
        final Holder menuHolder = new Holder();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                menuHolder.setValue((Object)((IFileChooserField)SwingScoutFileChooserField.this.getScoutObject()).getContextMenu().getChildActions());
            }
        };
        JobEx job = this.getSwingEnvironment().invokeScoutLater(t, 1200L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return MenuUtility.consolidateMenus((List)((List)menuHolder.getValue())).size() > 0;
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        if (this.getSwingTextField() instanceof JTextField) {
            int swingAlign = SwingUtility.createHorizontalAlignment(scoutAlign);
            ((JTextField)this.getSwingTextField()).setHorizontalAlignment(swingAlign);
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_dropdownIcon.setEnabled(b);
    }

    protected void setFileIconIdFromScout(String s) {
        this.m_dropdownIcon.setIconGroup(new IconGroup(this.getSwingEnvironment(), s));
    }

    @Override
    protected boolean handleSwingInputVerifier() {
        final String text = this.getSwingTextField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IFileChooserField)this.getScoutObject()).getDisplayText()) && ((IFileChooserField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IFileChooserField)SwingScoutFileChooserField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getSwingEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getSwingEnvironment().dispatchImmediateSwingJobs();
        return true;
    }

    @Override
    protected void handleSwingFocusGained() {
        super.handleSwingFocusGained();
        JTextComponent swingField = this.getSwingTextField();
        if (!this.isMenuOpened() && swingField.getDocument().getLength() > 0) {
            swingField.setCaretPosition(swingField.getDocument().getLength());
            swingField.moveCaretPosition(0);
        }
        this.setMenuOpened(false);
    }

    protected boolean isFileChooserEnabled() {
        return this.m_dropdownIcon.isEnabled();
    }

    protected void handleSwingFileChooserAction() {
        if (this.isFileChooserEnabled()) {
            Runnable scoutJob = new Runnable(){

                @Override
                public void run() {
                    IFileChooser fc = ((IFileChooserField)SwingScoutFileChooserField.this.getScoutObject()).getFileChooser();
                    final List files = fc.startChooser();
                    Runnable swingJob = new Runnable(){

                        @Override
                        public void run() {
                            if (CollectionUtility.hasElements((Collection)files)) {
                                SwingScoutFileChooserField.this.getSwingTextField().setText(((File)CollectionUtility.firstElement((List)files)).getAbsolutePath());
                                SwingScoutFileChooserField.this.handleSwingInputVerifier();
                            }
                        }
                    };
                    if (SwingScoutFileChooserField.this.getSwingEnvironment() != null) {
                        SwingScoutFileChooserField.this.getSwingEnvironment().invokeSwingLater(swingJob);
                    }
                }
            };
            this.getSwingEnvironment().invokeScoutLater(scoutJob, 0L);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("fileIconId")) {
            this.setFileIconIdFromScout((String)newValue);
        }
    }

    private class P_SwingFileChooserAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_SwingFileChooserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutFileChooserField.this.handleSwingFileChooserAction();
        }
    }
}

