/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.groupbox;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.border.AbstractBorder;

public class BackgroundBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1L;
    private Icon m_icon;
    private int m_halign;
    private int m_valign;

    public BackgroundBorder(Icon icon, int halign, int valign) {
        this.m_icon = icon;
        this.m_halign = halign;
        this.m_valign = valign;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (this.m_icon != null) {
            int iconW = this.m_icon.getIconWidth();
            int iconH = this.m_icon.getIconHeight();
            int anchorX = x;
            int anchorY = y;
            switch (this.m_halign) {
                case 2: {
                    anchorX = x;
                    break;
                }
                case 0: {
                    anchorX = x + (w - iconW) / 2;
                    break;
                }
                case 4: {
                    anchorX = x + (w - iconW);
                }
            }
            switch (this.m_valign) {
                case 1: {
                    anchorY = y;
                    break;
                }
                case 0: {
                    anchorY = y + (h - iconH) / 2;
                    break;
                }
                case 3: {
                    anchorY = y + (h - iconH);
                }
            }
            this.m_icon.paintIcon(c, g, anchorX, anchorY);
        }
    }
}

