/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.layout;

import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.Cell;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.IMultiSplitStrategy;

class CellSplit {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CellSplit.class);
    private boolean m_rowSplit;
    private int m_row;
    private int m_col;
    private Cell m_leftItem;
    private Cell m_rightItem;
    private boolean m_fixed;
    private int m_location;
    private IMultiSplitStrategy m_strategy;
    private boolean m_usedInModel;

    public CellSplit(boolean rowSplit, int row, int col, boolean fixed, Cell leftItem, Cell rightItem, int location) {
        this(rowSplit, row, col, fixed, leftItem, rightItem, location, null);
    }

    public CellSplit(boolean rowSplit, int row, int col, boolean fixed, Cell leftItem, Cell rightItem, int location, IMultiSplitStrategy strategy) {
        this.m_fixed = fixed;
        this.m_row = row;
        this.m_col = col;
        this.m_rowSplit = rowSplit;
        this.m_leftItem = leftItem;
        this.m_rightItem = rightItem;
        this.m_location = location;
        this.m_strategy = strategy;
    }

    public int getLocation() {
        return this.m_strategy != null ? this.m_strategy.getSplitLocation(this.m_row, this.m_col) : this.m_location;
    }

    public void setLocation(int loc) {
        if (loc == this.m_location) {
            return;
        }
        this.m_location = loc;
        if (this.m_strategy != null) {
            this.m_strategy.setSplitLocation(this.m_row, this.m_col, loc);
        }
    }

    public boolean isFixed() {
        return this.m_fixed;
    }

    public boolean isRowSplit() {
        return this.m_rowSplit;
    }

    public boolean isColumnSplit() {
        return !this.m_rowSplit;
    }

    public Cell getLeftItem() {
        return this.m_leftItem;
    }

    public Cell getRightItem() {
        return this.m_rightItem;
    }

    public boolean isUsedInModel() {
        return this.m_usedInModel;
    }

    public void setUsedInModel(boolean usedInModel) {
        this.m_usedInModel = usedInModel;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()) + "[" + (this.m_rowSplit ? "rowsplit " : "colsplit ") + (this.m_fixed ? "fixed " : "") + this.m_location + " " + VerboseUtility.dumpObject((Object)this.m_leftItem) + " " + VerboseUtility.dumpObject((Object)this.m_rightItem) + "]";
    }
}

