/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.layout;

import java.awt.Dimension;
import java.util.Set;
import javax.swing.JInternalFrame;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.CellSplit;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.ViewElement;

class ViewSplit {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ViewSplit.class);
    private Set<CellSplit> m_cellSplits;
    private Set<ViewElement> m_leftViews;
    private Set<ViewElement> m_rightViews;

    ViewSplit(Set<CellSplit> cellSplits) {
        this.m_cellSplits = cellSplits;
    }

    public ViewSplit(Set<CellSplit> cellSplits, Set<ViewElement> leftViews, Set<ViewElement> rightViews) {
        this.m_cellSplits = cellSplits;
        this.m_leftViews = leftViews;
        this.m_rightViews = rightViews;
    }

    public Set<CellSplit> getCellSplits() {
        return this.m_cellSplits;
    }

    public Set<ViewElement> getLeftViews() {
        return this.m_leftViews;
    }

    public Set<ViewElement> getRightViews() {
        return this.m_rightViews;
    }

    public int getLocation() {
        int i = 0;
        for (CellSplit s : this.m_cellSplits) {
            i += s.getLocation();
        }
        return i /= Math.max(1, this.m_cellSplits.size());
    }

    public void setLocation(int loc) {
        if (!this.isFixed()) {
            for (CellSplit s : this.m_cellSplits) {
                s.setLocation(loc);
            }
        }
    }

    public int move(int delta, boolean force) {
        if (delta != 0) {
            if (!force) {
                int limit;
                boolean right = delta > 0;
                int leftSideLimit = 0;
                int rightSideLimit = 0;
                if (!this.isFixed()) {
                    int distanceToMax;
                    int distanceToMin;
                    int[] bounds;
                    leftSideLimit = 10240;
                    rightSideLimit = 10240;
                    for (ViewElement v : this.m_leftViews) {
                        bounds = this.getResizeDistances(v, this.isRowSplit() ? v.top : v.left);
                        distanceToMin = bounds[0];
                        distanceToMax = bounds[1];
                        leftSideLimit = right ? Math.min(leftSideLimit, distanceToMax) : Math.min(leftSideLimit, -distanceToMin);
                    }
                    for (ViewElement v : this.m_rightViews) {
                        bounds = this.getResizeDistances(v, this.isRowSplit() ? v.bottom : v.right);
                        distanceToMin = bounds[0];
                        distanceToMax = bounds[1];
                        rightSideLimit = right ? Math.min(rightSideLimit, -distanceToMin) : Math.min(rightSideLimit, distanceToMax);
                    }
                }
                if ((limit = Math.min(leftSideLimit, rightSideLimit)) > 0) {
                    if (right) {
                        if (delta > limit) {
                            delta = limit;
                        }
                    } else if (delta < -limit) {
                        delta = -limit;
                    }
                    this.setLocation(this.getLocation() + delta);
                    return delta;
                }
                return 0;
            }
            int limit = Math.abs(delta);
            this.setLocation(this.getLocation() + delta);
            return delta;
        }
        return 0;
    }

    public boolean isFixed() {
        for (CellSplit s : this.m_cellSplits) {
            if (!s.isFixed()) continue;
            return true;
        }
        return false;
    }

    public boolean isRowSplit() {
        for (CellSplit s : this.m_cellSplits) {
            if (!s.isRowSplit()) continue;
            return true;
        }
        return false;
    }

    private int[] getResizeDistances(ViewElement v, ViewSplit oppositeSplit) {
        JInternalFrame comp = v.getFrame();
        if (comp == null || oppositeSplit == null) {
            return new int[2];
        }
        Dimension[] d = SwingLayoutUtility.getValidatedSizes(comp);
        int splitSize = Math.abs(oppositeSplit.getLocation() - this.getLocation());
        if (this.isRowSplit()) {
            return this.getResizeDistances(d[0].height, splitSize, d[2].height);
        }
        return this.getResizeDistances(d[0].width, splitSize, d[2].width);
    }

    private int[] getResizeDistances(int min, int value, int max) {
        if (value < min) {
            int[] nArray = new int[2];
            nArray[1] = max - value;
            return nArray;
        }
        if (value > max) {
            int[] nArray = new int[2];
            nArray[0] = min - value;
            return nArray;
        }
        return new int[]{min - value, max - value};
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + (this.isFixed() ? "fixed " : "") + this.getLocation() + "]";
    }
}

