/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.status;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.perf.IPerformanceAnalyzerService;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.job.SwingProgressHandler;
import org.eclipse.scout.service.SERVICES;

public class SwingScoutStatusBar
extends SwingScoutComposite<IDesktop> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutStatusBar.class);
    public static final int VISIBLE_ALWAYS = 0;
    public static final int VISIBLE_WHEN_BUSY = 1;
    public static final int VISIBLE_WHEN_TEXT_OR_BUSY = 2;
    private static final String CARD_LOGO = "logo";
    private static final String CARD_ACTIVITY = "activity";
    private int m_visibilityPolicy;
    private boolean m_jobRunning;
    private JLabel m_swingStatusLabel;
    private JPanel m_swingCardPanel;
    private JProgressBar m_swingProgressBar;
    private JButton m_swingStopButton;
    private JLabel m_swingNetworkLatency;
    private Icon m_iconNetworkLatencyGreen;
    private Icon m_iconNetworkLatencyYellow;
    private Icon m_iconNetworkLatencyRed;
    private SwingProgressHandler.IStateChangeListener m_progressListener;
    private PropertyChangeListener m_perfListener;

    public SwingScoutStatusBar(int visibilityPolicy) {
        this.setVisibilityPolicy(visibilityPolicy);
    }

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        this.m_iconNetworkLatencyGreen = Activator.getIcon("network_latency_green");
        this.m_iconNetworkLatencyYellow = Activator.getIcon("network_latency_yellow");
        this.m_iconNetworkLatencyRed = Activator.getIcon("network_latency_red");
        Icon icon = UIManager.getIcon("StatusBar.StopButton.icon");
        this.m_swingStopButton = new JButton(icon);
        this.m_swingStopButton.putClientProperty("SwingBusyIndicator.busyClickable", true);
        this.m_swingStopButton.setFocusable(false);
        this.m_swingStopButton.setHorizontalAlignment(0);
        this.m_swingStopButton.setMargin(new Insets(0, 4, 0, 3));
        this.m_swingStopButton.addActionListener(new SwingProgressHandler.CancelJobsAction());
        this.m_swingStopButton.setCursor(Cursor.getPredefinedCursor(0));
        this.m_swingProgressBar = new JProgressBar(0, 100);
        this.m_swingProgressBar.setOpaque(false);
        this.m_swingProgressBar.setBorder(new EmptyBorder(1, 2, 1, 2));
        this.m_swingProgressBar.setStringPainted(true);
        this.m_swingProgressBar.setString("");
        this.m_swingProgressBar.setIndeterminate(true);
        this.m_swingStatusLabel = new JLabel("Ok");
        this.m_swingStatusLabel.setOpaque(false);
        JPanelEx cardLogo = new JPanelEx(new FlowLayoutEx(4, 0, 0));
        cardLogo.setOpaque(false);
        icon = UIManager.getIcon("StatusBar.icon");
        if (icon != null) {
            JLabel logo = new JLabel();
            logo.setIcon(icon);
            cardLogo.add(logo);
        }
        this.m_swingNetworkLatency = new JLabel();
        this.m_swingNetworkLatency.setPreferredSize(new Dimension(16, 22));
        cardLogo.add(this.m_swingNetworkLatency);
        JPanelEx cardActivity = new JPanelEx(new FlowLayoutEx(4, 4, 0));
        cardActivity.add(this.m_swingProgressBar);
        cardActivity.add(this.m_swingStopButton);
        this.m_swingCardPanel = new JPanelEx(new CardLayout());
        this.m_swingCardPanel.add((Component)cardLogo, CARD_LOGO);
        this.m_swingCardPanel.add((Component)cardActivity, CARD_ACTIVITY);
        P_SwingStatusBarPanel bar = new P_SwingStatusBarPanel();
        bar.setLayout(new BorderLayoutEx());
        bar.add((Component)this.m_swingStatusLabel, "Center");
        bar.add((Component)this.m_swingCardPanel, "East");
        this.showCard(CARD_LOGO);
        int h = UIManager.getInt("StatusBar.height");
        if (h <= 0) {
            h = 29;
        }
        bar.setMinimumSize(new Dimension(0, h));
        bar.setPreferredSize(new Dimension(800, h));
        bar.setMaximumSize(new Dimension(2048, h));
        this.setSwingField(bar);
    }

    public JPanel getSwingStatusBar() {
        return (JPanel)this.getSwingField();
    }

    public void setVisibilityPolicy(int p) {
        switch (p) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid visibilityPolicy " + p);
            }
        }
        this.m_visibilityPolicy = p;
    }

    public int getVisibilityPolicy() {
        return this.m_visibilityPolicy;
    }

    private void showCard(String card) {
        if (this.m_swingCardPanel != null) {
            CardLayout l = (CardLayout)this.m_swingCardPanel.getLayout();
            l.show(this.m_swingCardPanel, card);
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setStatusFromScout();
        this.updateFieldVisibilities();
        if (this.m_progressListener == null) {
            this.m_progressListener = new SwingProgressHandler.IStateChangeListener(){

                @Override
                public void stateChanged(SwingProgressHandler handler) {
                    SwingScoutStatusBar.this.handleProgressChangeInSwingThread(handler);
                }
            };
            SwingProgressHandler progressHandler = SwingProgressHandler.getInstance();
            if (progressHandler != null) {
                progressHandler.addStateChangeListener(this.m_progressListener);
            }
        }
        if (this.m_perfListener == null) {
            this.m_perfListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if ("networkLatency".equals(e.getPropertyName())) {
                        SwingScoutStatusBar.this.handleNetworkLatencyChanged((Long)e.getNewValue());
                    }
                }
            };
            IPerformanceAnalyzerService perf = (IPerformanceAnalyzerService)SERVICES.getService(IPerformanceAnalyzerService.class);
            if (perf != null) {
                perf.addPropertyChangeListener(this.m_perfListener);
            }
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_progressListener != null) {
            SwingProgressHandler progressHandler = SwingProgressHandler.getInstance();
            if (progressHandler != null) {
                progressHandler.removeStateChangeListener(this.m_progressListener);
            }
            this.m_progressListener = null;
        }
        if (this.m_perfListener != null) {
            IPerformanceAnalyzerService perf = (IPerformanceAnalyzerService)SERVICES.getService(IPerformanceAnalyzerService.class);
            if (perf != null) {
                perf.removePropertyChangeListener(this.m_perfListener);
            }
            this.m_perfListener = null;
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("status")) {
            this.setStatusFromScout();
        }
    }

    protected void handleNetworkLatencyChanged(final Long value) {
        if (this.m_swingNetworkLatency != null) {
            Icon icon = null;
            icon = value <= 70L ? this.m_iconNetworkLatencyGreen : (value <= 200L ? this.m_iconNetworkLatencyYellow : this.m_iconNetworkLatencyRed);
            final Icon iconf = icon;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingScoutStatusBar.this.m_swingNetworkLatency.setToolTipText(String.valueOf(SwingUtility.getNlsText("NetworkLatency", new String[0])) + " " + value + "ms");
                    if (iconf != SwingScoutStatusBar.this.m_swingNetworkLatency.getIcon()) {
                        SwingScoutStatusBar.this.m_swingNetworkLatency.setIcon(iconf);
                    }
                }
            });
        }
    }

    private void handleProgressChangeInSwingThread(SwingProgressHandler h) {
        this.m_jobRunning = h.isJobRunning();
        if (this.m_swingProgressBar != null) {
            Integer newValue = null;
            String newText = null;
            if (h.isJobRunning()) {
                double f = h.getJobWorked();
                newValue = f <= 0.0 ? null : Integer.valueOf((int)(f * 100.0));
                newText = h.getJobFullName();
                if (newText == null || newText.length() == 0) {
                    newText = this.m_swingProgressBar.getValue() > 0 ? null : "";
                } else {
                    this.m_swingProgressBar.setStringPainted(true);
                }
            } else {
                newText = "";
                newValue = null;
            }
            this.m_swingProgressBar.setString(newText);
            this.m_swingProgressBar.setIndeterminate(newValue == null);
            this.m_swingProgressBar.setValue(newValue != null ? newValue : 0);
        }
        this.updateFieldVisibilities();
    }

    protected void setStatusFromScout() {
        this.setSwingStatus(((IDesktop)this.getScoutObject()).getStatus());
    }

    public void setSwingStatus(IProcessingStatus newStatus) {
        String newText = null;
        Icon newIcon = null;
        if (newStatus != null && !StringUtility.isNullOrEmpty((String)newStatus.getMessage())) {
            newText = newStatus.getMessage();
            switch (newStatus.getSeverity()) {
                case 4: 
                case 16: {
                    newIcon = this.getSwingEnvironment().getIcon("status_error");
                    break;
                }
                case 2: {
                    newIcon = this.getSwingEnvironment().getIcon("status_warning");
                    break;
                }
                case 1: {
                    newIcon = this.getSwingEnvironment().getIcon("status_info");
                }
            }
        }
        this.m_swingStatusLabel.setText(newText);
        this.m_swingStatusLabel.setIcon(newIcon);
        this.updateFieldVisibilities();
    }

    protected void updateFieldVisibilities() {
        boolean hasJob = this.m_jobRunning;
        boolean hasStatus = this.m_swingStatusLabel.getText() != null && this.m_swingStatusLabel.getText().length() > 0;
        boolean hasAny = hasJob || hasStatus;
        boolean panelVisible = true;
        switch (this.m_visibilityPolicy) {
            case 0: {
                panelVisible = true;
                break;
            }
            case 1: 
            case 2: {
                panelVisible = hasAny;
            }
        }
        this.getSwingStatusBar().setVisible(panelVisible);
        this.showCard(hasAny ? CARD_ACTIVITY : CARD_LOGO);
        this.m_swingStatusLabel.setVisible(hasStatus);
        this.m_swingProgressBar.setVisible(hasJob);
        this.m_swingStopButton.setVisible(hasJob);
        this.m_swingStopButton.setEnabled(true);
    }

    private class P_SwingStatusBarPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public P_SwingStatusBarPanel() {
            this.setOpaque(false);
            this.setBorder(new EmptyBorder(4, 9, 0, 9));
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(new GradientPaint(new Point(0, 0), new Color(0xB7B7B7), new Point(0, 4), new Color(0xF4F4F4)));
            g2d.fillRect(0, 0, this.getWidth(), 4);
            super.paint(g);
        }
    }
}

