/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarItemContainer;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCalendarItem;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.MonthCalendarItem;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.MonthCell;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SwtCalendar;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.WeekCalendarItem;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.WeekCell;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractCell
extends Composite
implements PaintListener {
    protected static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCell.class);
    public static final Color BACKGROUND = SwtColors.getInstance().getWhite();
    public static final Color BORDER_SELECTED_COLOR = SwtColors.getInstance().getBlue();
    public static final Color BORDER_UNSELECTED_COLOR = SwtColors.getInstance().getGray();
    private Color background = BACKGROUND;
    private SwtCalendar m_calendar;
    private Calendar m_cellDate;
    private boolean m_isFirstColumn;
    private boolean m_isCurrentPeriod;
    private boolean m_isSelected = false;
    private String m_weekText = null;
    private String m_dayText = null;
    private TreeSet<CalendarItemContainer> m_itemsCached;
    private ArrayList<AbstractCalendarItem> m_widgetItems = new ArrayList();
    private int m_countTimeless;
    private Menu m_contextMenu;

    public AbstractCell(Composite parent, int style) {
        super(parent, style);
        this.setupMenu();
    }

    protected void setupMenu() {
        this.m_contextMenu = new Menu((Decorations)this.getShell(), 8);
        this.setMenu(this.m_contextMenu);
    }

    public synchronized Collection<CalendarItemContainer> getItems() {
        if (this.m_itemsCached == null) {
            this.m_itemsCached = new TreeSet();
            this.m_countTimeless = 0;
            Collection<CalendarComponent> items = this.m_calendar.getModel().getItemsAt(this.getDate().getTime());
            if (items != null) {
                try {
                    for (CalendarComponent item : items) {
                        this.m_itemsCached.add(new CalendarItemContainer(item, this));
                    }
                }
                catch (ConcurrentModificationException cme) {
                    LOG.warn("ConcurrentModificationException on getItems");
                    return this.m_itemsCached;
                }
            }
            if (!this.m_itemsCached.isEmpty()) {
                ArrayList<ItemBoundsOrganizer> seen = new ArrayList<ItemBoundsOrganizer>();
                ArrayList<ItemBoundsOrganizer> conflict = new ArrayList<ItemBoundsOrganizer>();
                int horizontalSlotCount = 0;
                for (CalendarItemContainer calendarItemContainer : this.m_itemsCached) {
                    if (!calendarItemContainer.isTimed()) continue;
                    ItemBoundsOrganizer newNode = new ItemBoundsOrganizer(calendarItemContainer);
                    conflict.clear();
                    int minLevel = 0;
                    for (ItemBoundsOrganizer oldNode : seen) {
                        if (!oldNode.getCC().intersects(newNode.getCC())) continue;
                        conflict.add(oldNode);
                        minLevel = Math.max(minLevel, oldNode.getMinLevel() + 1);
                    }
                    newNode.setMinLevel(minLevel);
                    horizontalSlotCount = Math.max(horizontalSlotCount, minLevel + 1);
                    seen.add(newNode);
                    for (ItemBoundsOrganizer node : conflict) {
                        node.limitMaxLevel(minLevel - 1);
                    }
                }
                for (ItemBoundsOrganizer itemBoundsOrganizer : seen) {
                    itemBoundsOrganizer.saveHorizontalExtents(horizontalSlotCount);
                }
                for (CalendarItemContainer calendarItemContainer : this.m_itemsCached) {
                    if (calendarItemContainer.isTimed()) continue;
                    calendarItemContainer.setHorizontalExtents(0.0f, 1.0f);
                    ++this.m_countTimeless;
                }
                return this.m_itemsCached;
            }
            return null;
        }
        return this.m_itemsCached;
    }

    public int getCountTimelessItems() {
        return this.m_countTimeless;
    }

    public void reloadCalendarItems() {
        this.disposeCalendarItems();
        this.m_itemsCached = null;
        this.addCalendarItems();
    }

    public SwtCalendar getCalendar() {
        return this.m_calendar;
    }

    protected void setCalendar(SwtCalendar calendar) {
        this.m_calendar = calendar;
    }

    protected ArrayList<AbstractCalendarItem> getWidgetItems() {
        return this.m_widgetItems;
    }

    public void paintControl(PaintEvent e) {
        this.setBackground(this.background);
        this.drawLabels(e);
        this.drawTimeline(e);
        this.drawBorder(e);
    }

    protected abstract void drawLabels(PaintEvent var1);

    protected void drawDayLabel(PaintEvent e) {
        if (this.m_dayText != null) {
            e.gc.setForeground(SwtColors.getInstance().getBlack());
            Rectangle bounds = this.getBounds();
            Point ext = e.gc.stringExtent(this.m_dayText);
            e.gc.drawString(this.m_dayText, bounds.width - 2 - ext.x, 1, true);
        }
    }

    protected void drawWeekLabel(PaintEvent e) {
        if (this.m_dayText != null) {
            e.gc.setForeground(SwtColors.getInstance().getBlack());
            e.gc.drawString(this.m_weekText, 3, 1, true);
        }
    }

    protected void drawBorder(PaintEvent e) {
        if (this.m_isSelected) {
            e.gc.setForeground(BORDER_SELECTED_COLOR);
        } else {
            e.gc.setForeground(BORDER_UNSELECTED_COLOR);
        }
        Rectangle bounds = this.getBounds();
        e.gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        e.gc.setForeground(BORDER_UNSELECTED_COLOR);
    }

    protected void drawTimeline(PaintEvent e) {
    }

    public void setSelected() {
        if (!this.m_isCurrentPeriod) {
            this.m_calendar.setViewDate(this.m_cellDate);
        }
        this.m_calendar.setSelectedItem(null);
        this.m_calendar.setSelectedDateFromUI(this.m_cellDate);
    }

    protected void hookListeners() {
        this.addPaintListener(this);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AbstractCell.this.setSelected();
            }
        });
        this.m_contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener());
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 16: 
                    case 64: {
                        Calendar newDate = Calendar.getInstance();
                        newDate.setTime(AbstractCell.this.m_cellDate.getTime());
                        newDate.add(5, 1);
                        AbstractCell cell = AbstractCell.this.m_calendar.getCentralPanel().getCellFromDate(newDate.getTime());
                        if (cell != null) {
                            cell.setSelected();
                        }
                        e.doit = false;
                        break;
                    }
                    case 8: 
                    case 32: {
                        Calendar newDate = Calendar.getInstance();
                        newDate.setTime(AbstractCell.this.m_cellDate.getTime());
                        newDate.add(5, -1);
                        AbstractCell cell = AbstractCell.this.m_calendar.getCentralPanel().getCellFromDate(newDate.getTime());
                        if (cell != null) {
                            cell.setSelected();
                        }
                        e.doit = false;
                    }
                }
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                AbstractCell.this.dispose();
            }
        });
    }

    public void setSelected(boolean selected) {
        if (this.m_isSelected == selected) {
            return;
        }
        this.m_isSelected = selected;
        this.redraw();
    }

    protected void setSelectedInternal(boolean selected) {
        this.m_isSelected = selected;
    }

    public boolean getSelected() {
        return this.m_isSelected;
    }

    public void setDayText(String text) {
        this.m_dayText = text;
    }

    public void setWeekText(String text) {
        this.m_weekText = text;
    }

    public Calendar getDate() {
        return this.m_cellDate;
    }

    protected void setDate(Calendar cellDate) {
        this.m_cellDate = cellDate;
    }

    protected boolean isFirstColumn() {
        return this.m_isFirstColumn;
    }

    protected void setFirstColumn(boolean isFirstColumn) {
        this.m_isFirstColumn = isFirstColumn;
    }

    protected boolean isCurrentPeriod() {
        return this.m_isCurrentPeriod;
    }

    protected void setCurrentPeriod(boolean isCurrentPeriod) {
        this.m_isCurrentPeriod = isCurrentPeriod;
    }

    protected void setVisualState() {
        String weekName = this.m_isFirstColumn ? String.valueOf(SwtUtility.getNlsText(Display.getCurrent(), "WeekShort", new String[0])) + " " + this.m_cellDate.get(3) : "";
        String day = new SimpleDateFormat("dd.MMM", Locale.getDefault()).format(this.m_cellDate.getTime());
        this.setDayText(day);
        this.setWeekText(weekName);
        this.setBackground(SwtColors.getInstance().getWhite());
        if (!this.m_isCurrentPeriod && this.m_calendar.getMarkOutOfMonthDays()) {
            this.setBackground(SwtColors.getInstance().getLightgray());
        }
    }

    protected void addCalendarItems() {
        Collection<CalendarItemContainer> items = this.getItems();
        if (items != null) {
            Iterator<CalendarItemContainer> iterator = this.getItems().iterator();
            while (iterator.hasNext()) {
                CalendarItemContainer element;
                CalendarItemContainer item = element = iterator.next();
                if (this instanceof WeekCell) {
                    this.m_widgetItems.add(new WeekCalendarItem(this, 0, item));
                    continue;
                }
                if (!(this instanceof MonthCell)) continue;
                this.m_widgetItems.add(new MonthCalendarItem(this, 0, item));
            }
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.background = c;
    }

    protected void disposeCalendarItems() {
        if (this.m_widgetItems != null) {
            for (AbstractCalendarItem item : this.m_widgetItems) {
                if (item == null || item.isDisposed()) continue;
                item.dispose();
            }
            this.m_widgetItems = new ArrayList();
        }
    }

    public void dispose() {
        this.disposeCalendarItems();
        super.dispose();
    }

    public static long getTimeOfDayMillis(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        long timeRel = (((long)c.get(11) * 60L + (long)c.get(12)) * 60L + (long)c.get(13)) * 1000L + (long)c.get(14);
        c.set(10, 0);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long dayAbs = c.getTimeInMillis();
        return dayAbs + timeRel;
    }

    public String toString() {
        SimpleDateFormat weekDayFmt = new SimpleDateFormat("EEEEE", Locale.getDefault());
        DateFormat dateFmt = new DateTimeFormatFactory().getDayMonthYear(1);
        return "AbstractCell {" + weekDayFmt.format(this.m_cellDate.getTime()) + " " + dateFmt.format(this.m_cellDate.getTime()) + "}";
    }

    private class ItemBoundsOrganizer {
        private CalendarItemContainer m_cc;
        private int m_minLevel;
        private int m_maxLevel = 100000;

        public ItemBoundsOrganizer(CalendarItemContainer cc) {
            this.m_cc = cc;
        }

        public CalendarItemContainer getCC() {
            return this.m_cc;
        }

        public int getMinLevel() {
            return this.m_minLevel;
        }

        public void setMinLevel(int i) {
            this.m_minLevel = i;
        }

        public void limitMaxLevel(int maximumValue) {
            this.m_maxLevel = Math.min(this.m_maxLevel, maximumValue);
        }

        private void saveHorizontalExtents(int horizontalSlotCount) {
            float x0 = 1.0f * (float)this.m_minLevel / (float)horizontalSlotCount;
            float x1 = 1.0f * (float)Math.min(this.m_maxLevel + 1, horizontalSlotCount) / (float)horizontalSlotCount;
            this.m_cc.setHorizontalExtents(x0, x1);
        }

        public String toString() {
            return "BoundsOrganizer[" + this.m_cc + "]";
        }
    }

    private class P_ContextMenuListener
    extends MenuAdapter {
        private P_ContextMenuListener() {
        }

        public void menuShown(MenuEvent e) {
            if (AbstractCell.this.m_contextMenu != null) {
                MenuItem[] menuItemArray = AbstractCell.this.m_contextMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    this.disposeMenuItem(item);
                    ++n2;
                }
            }
            AbstractCell.this.m_calendar.showContextMenu(AbstractCell.this.m_contextMenu);
        }

        private void disposeMenuItem(MenuItem item) {
            Menu menu = item.getMenu();
            if (menu != null) {
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem childItem = menuItemArray[n2];
                    this.disposeMenuItem(childItem);
                    ++n2;
                }
                menu.dispose();
            }
            item.dispose();
        }
    }
}

