/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext.table.internal;

import java.text.BreakIterator;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableMultilineListener
implements Listener {
    private final int m_text_margin_y;
    private final int m_text_margin_x;
    private static final int IMAGE_TEXT_PADDING = 1;
    private static final String LINE_SEPARATOR = "\n";
    private final boolean m_multiline;
    private final int m_rowHeight;
    private final Set<Integer> m_wrapTextColumns;

    public TableMultilineListener(boolean multiline, int rowHeight, Set<Integer> wrapTextColumns, int textMarginX, int textMarginY) {
        this.m_multiline = multiline;
        this.m_rowHeight = rowHeight;
        this.m_wrapTextColumns = wrapTextColumns;
        this.m_text_margin_y = textMarginY;
        this.m_text_margin_x = textMarginX;
    }

    public int getRowHeight() {
        return this.m_rowHeight;
    }

    protected String softWrapText(GC gc, String text, Rectangle bounds) {
        if (StringUtility.isNullOrEmpty((String)text)) {
            return text;
        }
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        int saved = 0;
        int last = 0;
        int width = bounds.width;
        String wrappedText = "";
        int loc = wb.first();
        while (loc != -1) {
            String line = text.substring(saved, loc);
            int textWidth = this.getTextWidth(gc, line);
            if (textWidth > width) {
                String prevLine = text.substring(saved, last);
                wrappedText = String.valueOf(wrappedText) + prevLine.trim();
                wrappedText = String.valueOf(wrappedText) + LINE_SEPARATOR;
                saved = last;
            }
            last = loc;
            loc = wb.next();
        }
        String lastLine = text.substring(saved, last);
        wrappedText = String.valueOf(wrappedText) + lastLine.trim();
        return wrappedText;
    }

    protected int getTextWidth(GC gc, String line) {
        return gc.textExtent((String)line).x;
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 41: {
                Point mSize = new Point(0, 0);
                TableItem mitem = (TableItem)event.item;
                Image img = mitem.getImage(event.index);
                int editableIconOffset = 0;
                if (img != null) {
                    editableIconOffset = 1;
                    Rectangle imgBounds = img.getBounds();
                    img.getBounds().width += editableIconOffset;
                    mSize.x += imgBounds.width + 2;
                    mSize.y = Math.max(mSize.y, imgBounds.height + 2 * this.m_text_margin_y);
                }
                String mtext = this.getCelldisplayText(event, mitem);
                Point textSize = this.m_multiline ? event.gc.textExtent(mtext) : event.gc.stringExtent(mtext);
                mSize.x += textSize.x + 2 * this.m_text_margin_x;
                mSize.y = Math.max(mSize.y, textSize.y + 2 * this.m_text_margin_y);
                event.width = mSize.x + editableIconOffset;
                event.height = Math.max(event.height, mSize.y);
                break;
            }
            case 42: {
                TableItem pitem = (TableItem)event.item;
                String ptext = this.getCelldisplayText(event, pitem);
                int align = 16384;
                TableColumn tc = pitem.getParent().getColumn(event.index);
                if (tc != null) {
                    align = tc.getStyle() & 0x1024000;
                }
                Rectangle itemBounds = pitem.getBounds(event.index);
                boolean editableIconOffset = true;
                int xImageOffset = itemBounds.x;
                int xTextOffset = xImageOffset + this.m_text_margin_x;
                int yOffset = itemBounds.y + this.m_text_margin_y;
                Point textExtent = event.gc.stringExtent(ptext);
                Image pImg = pitem.getImage(event.index);
                Rectangle contentBounds = null;
                if (pImg != null) {
                    contentBounds = pImg.getBounds();
                    if (textExtent.x > 0) {
                        ++contentBounds.width;
                        xTextOffset += contentBounds.width;
                    }
                } else {
                    contentBounds = new Rectangle(0, 0, 0, 0);
                }
                contentBounds.width += textExtent.x;
                contentBounds.height += textExtent.y;
                if (align == 131072) {
                    int dx = Math.max(this.m_text_margin_x, itemBounds.x + itemBounds.width - xImageOffset - contentBounds.width - this.m_text_margin_x);
                    xTextOffset += dx;
                } else if (align == 0x1000000) {
                    int dx = Math.max(this.m_text_margin_x, (itemBounds.x + itemBounds.width - xImageOffset - contentBounds.width - this.m_text_margin_x) / 2);
                    xTextOffset += dx;
                }
                if (pImg != null) {
                    event.gc.drawImage(pImg, xImageOffset, yOffset);
                }
                event.gc.drawText(ptext, xTextOffset, yOffset, true);
                event.gc.setForeground(event.gc.getDevice().getSystemColor(19));
                break;
            }
            case 40: {
                event.detail &= 0xFFFFFFFB;
                event.detail &= 0xFFFFFFEF;
            }
        }
    }

    protected String getCelldisplayText(Event event, TableItem item) {
        Rectangle itemBounds = item.getBounds(event.index);
        String text = item.getText(event.index);
        if (StringUtility.hasText((String)text)) {
            FontMetrics fm;
            if (this.isWrapped(event.index, item.getParent())) {
                text = this.softWrapText(event.gc, text, new Rectangle(itemBounds.x, itemBounds.y, itemBounds.width - this.m_text_margin_x * 2, itemBounds.height - this.m_text_margin_y * 2));
            }
            if ((fm = event.gc.getFontMetrics()) != null) {
                int fontHeight = fm.getHeight();
                text = this.trimToRowHeight(text, fontHeight);
            }
        }
        return text;
    }

    private boolean isEditableIconNeeded(Event event, TableItem item) {
        IColumn col = (IColumn)item.getParent().getColumn(event.index).getData("scoutColumn");
        return col != null && col.isEditable() && !col.getDataType().isAssignableFrom(Boolean.class);
    }

    private boolean isWrapped(int uiColumnIndex, Table table) {
        IColumn scoutColumn = (IColumn)table.getColumn(uiColumnIndex).getData("scoutColumn");
        if (scoutColumn == null) {
            return false;
        }
        return CollectionUtility.containsAny(this.m_wrapTextColumns, (Object[])new Integer[]{scoutColumn.getColumnIndex()});
    }

    protected String trimToRowHeight(String text, int lineHeight) {
        if (this.getRowHeight() > 0 && lineHeight > 0 && text != null) {
            int maxLineCount = this.getRowHeight() / lineHeight;
            int lineCount = Math.min(StringUtility.getLineCount((String)text), maxLineCount);
            String[] lines = StringUtility.getLines((String)text);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < lineCount - 1) {
                sb.append(lines[i]).append(LINE_SEPARATOR);
                ++i;
            }
            if (lineCount > 0) {
                sb.append(lines[lineCount - 1]);
            }
            text = sb.toString();
        }
        return text;
    }
}

