/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.imagebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageField;
import org.eclipse.scout.rt.ui.swt.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.action.menu.MenuPositionCorrectionListener;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtScoutContextMenu;
import org.eclipse.scout.rt.ui.swt.ext.ImageViewer;
import org.eclipse.scout.rt.ui.swt.ext.ScrolledFormEx;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.AbstractSwtScoutDndSupport;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.imagebox.ISwtScoutImageBox;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutImageField
extends SwtScoutFieldComposite<IImageField>
implements ISwtScoutImageBox {
    private Image m_image;
    private ImageViewer m_imageViewer;
    private ScrolledFormEx m_scrolledForm;
    private SwtContextMenuMarkerComposite m_menuMarkerComposite;
    private SwtScoutContextMenu m_contextMenu;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        this.m_menuMarkerComposite = new SwtContextMenuMarkerComposite(container, this.getEnvironment(), 0);
        this.getEnvironment().getFormToolkit().adapt((Composite)this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwtScoutImageField.this.getSwtField().setFocus();
                SwtScoutImageField.this.m_contextMenu.getSwtMenu().setVisible(true);
            }
        });
        Composite body = null;
        if (((IImageField)this.getScoutObject()).isScrollBarEnabled()) {
            this.m_scrolledForm = this.getEnvironment().getFormToolkit().createScrolledFormEx((Composite)this.m_menuMarkerComposite, 768);
            this.setSwtField((Control)this.m_scrolledForm);
            this.m_scrolledForm.setBackground(this.m_scrolledForm.getDisplay().getSystemColor(9));
            body = this.m_scrolledForm.getBody();
            this.m_scrolledForm.setData("SCROLLED_FORM", new Object());
        } else {
            body = this.getEnvironment().getFormToolkit().createComposite((Composite)this.m_menuMarkerComposite);
            this.setSwtField((Control)body);
        }
        body.setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot(body){

            @Override
            public void validate() {
                if (SwtScoutImageField.this.m_scrolledForm != null && !SwtScoutImageField.this.m_scrolledForm.isDisposed()) {
                    SwtScoutImageField.this.m_scrolledForm.reflow(true);
                }
            }
        });
        this.m_imageViewer = this.getEnvironment().getFormToolkit().createImageViewer(body);
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.m_imageViewer.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SwtScoutImageField.this.freeResources();
            }
        });
        LogicalGridLayout layout = new LogicalGridLayout(1, 0);
        this.getSwtContainer().setLayout((Layout)layout);
        this.m_menuMarkerComposite.setLayoutData(LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
        body.setLayout((Layout)new FillLayout());
    }

    @Override
    protected void installContextMenu() {
        int vAlign;
        int hAlign;
        this.m_menuMarkerComposite.setMarkerVisible(((IImageField)this.getScoutObject()).getContextMenu().isVisible());
        ((IImageField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    final boolean markerVisible = ((IImageField)SwtScoutImageField.this.getScoutObject()).getContextMenu().isVisible();
                    SwtScoutImageField.this.getEnvironment().invokeSwtLater(new Runnable(){

                        @Override
                        public void run() {
                            SwtScoutImageField.this.m_menuMarkerComposite.setMarkerVisible(markerVisible);
                        }
                    });
                }
            }
        });
        this.m_contextMenu = new SwtScoutContextMenu(this.getImageViewer().getShell(), ((IImageField)this.getScoutObject()).getContextMenu(), this.getEnvironment());
        this.getImageViewer().setMenu(this.m_contextMenu.getSwtMenu());
        switch (this.getImageViewer().getAlignmentX()) {
            case 16384: {
                hAlign = 1;
                break;
            }
            case 131072: {
                hAlign = 4;
                break;
            }
            default: {
                hAlign = 2;
            }
        }
        switch (this.getImageViewer().getAlignmentY()) {
            case 128: {
                vAlign = 8;
                break;
            }
            case 1024: {
                vAlign = 32;
                break;
            }
            default: {
                vAlign = 16;
            }
        }
        this.getImageViewer().addListener(35, new MenuPositionCorrectionListener((Control)this.getImageViewer(), hAlign | vAlign));
    }

    public ImageViewer getImageViewer() {
        return this.m_imageViewer;
    }

    private void freeResources() {
        if (this.m_image != null && !this.m_image.isDisposed()) {
            if (this.getSwtField() != null && !this.getSwtField().isDisposed()) {
                this.getImageViewer().setImage(null);
            }
            this.m_image.dispose();
            this.m_image = null;
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.getImageViewer().setAlignmentX(SwtUtility.getHorizontalAlignment(((IImageField)this.getScoutObject()).getGridData().horizontalAlignment));
        this.getImageViewer().setAlignmentY(SwtUtility.getVerticalAlignment(((IImageField)this.getScoutObject()).getGridData().verticalAlignment));
        this.updateAutoFitFromScout();
        this.updateImageFromScout();
        new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), this.getSwtField(), this.getEnvironment());
    }

    protected void updateImageFromScout() {
        this.freeResources();
        if (((IImageField)this.getScoutObject()).getImage() instanceof byte[]) {
            this.m_image = new Image((Device)this.getSwtField().getDisplay(), (InputStream)new ByteArrayInputStream((byte[])((IImageField)this.getScoutObject()).getImage()));
            this.getImageViewer().setImage(this.m_image);
        } else if (((IImageField)this.getScoutObject()).getImage() instanceof ImageData) {
            this.m_image = new Image((Device)this.getSwtField().getDisplay(), (ImageData)((IImageField)this.getScoutObject()).getImage());
            this.getImageViewer().setImage(this.m_image);
        } else if (!StringUtility.isNullOrEmpty((String)((IImageField)this.getScoutObject()).getImageId())) {
            this.getImageViewer().setImage(this.getEnvironment().getIcon(((IImageField)this.getScoutObject()).getImageId()));
        }
        this.getImageViewer().redraw();
    }

    protected void updateAutoFitFromScout() {
        this.getImageViewer().setAutoFit(((IImageField)this.getScoutObject()).isAutoFit());
    }

    @Override
    protected void setFocusableFromScout(boolean b) {
        ImageViewer imageViewer = this.getImageViewer();
        if (imageViewer != null) {
            imageViewer.setFocusable(b);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("imageId") || "image".equals(name)) {
            this.updateImageFromScout();
        } else if ("autoFit".equals(name)) {
            this.updateAutoFitFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    private class P_DndSupport
    extends AbstractSwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control, ISwtEnvironment environment) {
            super(scoutObject, scoutDndSupportable, control, environment);
        }

        @Override
        protected TransferObject handleSwtDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((IImageField)SwtScoutImageField.this.getScoutObject()).getUIFacade().fireDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            JobEx job = SwtScoutImageField.this.getEnvironment().invokeScoutLater(t, 2345L);
            try {
                job.join(2345L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleSwtDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    ((IImageField)SwtScoutImageField.this.getScoutObject()).getUIFacade().fireDropActionFromUi(scoutTransferObject);
                }
            };
            SwtScoutImageField.this.getEnvironment().invokeScoutLater(job, 200L);
        }
    }
}

