/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.snapbox.layout;

import org.eclipse.scout.rt.ui.swt.form.fields.snapbox.layout.SnapBoxLayoutData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SnapBoxMaximizedLayout
extends Layout {
    private int m_cachedItemHeight = 0;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(1, 1);
    }

    protected void layout(Composite composite, boolean flushCache) {
        this.computeMaximizedSize(composite, 0, 0);
        Control[] children = composite.getChildren();
        Rectangle clientArea = composite.getClientArea();
        int y = clientArea.y;
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            SnapBoxLayoutData layoutData = (SnapBoxLayoutData)child.getLayoutData();
            if (!layoutData.exclude && child.getVisible()) {
                boolean maximized;
                layoutData.maximized = maximized = y + this.m_cachedItemHeight < clientArea.height;
                if (maximized) {
                    child.setBounds(clientArea.x, y, clientArea.width, this.m_cachedItemHeight);
                    y += this.m_cachedItemHeight;
                } else {
                    child.setBounds(0, 0, 0, 0);
                }
            }
            ++n2;
        }
    }

    private Point computeMaximizedSize(Composite composite, int wHint, int hHint) {
        Control[] children;
        int maxChildHeight = 0;
        int maxChildWidth = 0;
        int visibleChildren = 0;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            SnapBoxLayoutData layoutData = (SnapBoxLayoutData)child.getLayoutData();
            if (!layoutData.exclude && child.getVisible()) {
                ++visibleChildren;
                Point prefSize = child.computeSize(wHint, -1, false);
                maxChildWidth = Math.max(prefSize.x, maxChildWidth);
                maxChildHeight = Math.max(prefSize.y, maxChildHeight);
            }
            ++n2;
        }
        this.m_cachedItemHeight = maxChildHeight;
        return new Point(maxChildWidth, visibleChildren * maxChildHeight);
    }
}

