/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.snapbox.layout;

import org.eclipse.scout.rt.ui.swt.form.fields.snapbox.layout.SnapBoxLayoutData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SnapBoxMinimizedLayout
extends Layout {
    private int m_iconSize = 20;
    private int m_gap = 2;
    private int m_insets = 2;

    protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
        Point size = new Point(0, 0);
        Control[] children = composite.getChildren();
        int visibleChildSize = 0;
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            SnapBoxLayoutData layoutData = (SnapBoxLayoutData)child.getLayoutData();
            if (!layoutData.exclude && !layoutData.maximized) {
                size.y = Math.max(size.y, this.m_iconSize);
                size.x += this.m_iconSize;
                ++visibleChildSize;
            }
            ++n2;
        }
        size.x += (visibleChildSize - 1) * this.m_gap;
        size.x += 2 * this.m_insets;
        size.y += 2 * this.m_insets;
        return size;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        Rectangle clientArea = composite.getClientArea();
        int x = clientArea.x + clientArea.width - this.m_iconSize - this.m_insets;
        int height = clientArea.height - 2 * this.m_insets;
        int i = children.length - 1;
        while (i >= 0) {
            boolean layouted;
            Control child = children[i];
            SnapBoxLayoutData layoutData = (SnapBoxLayoutData)child.getLayoutData();
            boolean bl = layouted = !layoutData.exclude && !layoutData.maximized;
            if (layouted) {
                child.setBounds(x, clientArea.y + this.m_insets, this.m_iconSize, height);
                x -= this.m_iconSize + this.m_gap;
            } else {
                child.setBounds(0, 0, 0, 0);
            }
            --i;
        }
    }
}

