/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.radiobuttongroup;

import java.util.ArrayList;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.MultilineRadioButton;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.ISwtScoutFormField;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.radiobuttongroup.ISwtScoutRadioButtonGroup;
import org.eclipse.scout.rt.ui.swt.form.radiobuttongroup.layout.RadioButtonGroupLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SwtScoutRadioButtonGroup
extends SwtScoutValueFieldComposite<IRadioButtonGroup<?>>
implements ISwtScoutRadioButtonGroup {
    private P_SwtButtonListener m_swtButtonListener = new P_SwtButtonListener();
    private ArrayList<MultilineRadioButton> m_swtRadioButtons = new ArrayList();

    @Override
    protected void initializeSwt(Composite parent) {
        boolean usesLogicalGrid;
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        P_RadioButtonComposite buttonArea = new P_RadioButtonComposite(container);
        this.getEnvironment().getFormToolkit().adapt(buttonArea);
        for (IFormField scoutField : ((IRadioButtonGroup)this.getScoutObject()).getFields()) {
            ISwtScoutFormField swtField = this.getEnvironment().createFormField(buttonArea, scoutField);
            if (!(swtField.getSwtField() instanceof MultilineRadioButton)) continue;
            MultilineRadioButton swtButton = (MultilineRadioButton)swtField.getSwtField();
            swtButton.addListener(13, this.m_swtButtonListener);
            swtButton.addListener(1, this.m_swtButtonListener);
            this.m_swtRadioButtons.add(swtButton);
            if (!swtButton.getSelection()) continue;
            buttonArea.setTabList(new Control[]{swtButton.getParent().getParent()});
        }
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)buttonArea);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
        GridData scoutGridData = ((IRadioButtonGroup)this.getScoutObject()).getGridData();
        boolean bl = usesLogicalGrid = ((IRadioButtonGroup)this.getScoutObject()).getGridRowCount() == scoutGridData.h && !scoutGridData.useUiHeight;
        if (usesLogicalGrid) {
            IUiDecoration deco = UiDecorationExtensionPoint.getLookAndFeel();
            this.getSwtField().setLayout((Layout)new RadioButtonGroupLayout((IRadioButtonGroup)this.getScoutObject(), deco.getLogicalGridLayoutHorizontalGap(), deco.getLogicalGridLayoutVerticalGap()));
        } else {
            this.getSwtField().setLayout((Layout)new RadioButtonGroupLayout((IRadioButtonGroup)this.getScoutObject(), 0, 4));
        }
    }

    public Composite getSwtField() {
        return (Composite)super.getSwtField();
    }

    @Override
    protected void setBackgroundFromScout(String scoutColor) {
        if (this.getSwtField() != null) {
            Composite fld = this.getSwtField();
            if (fld.getData("scoutInitialBackground") == null) {
                fld.setData("scoutInitialBackground", (Object)fld.getBackground());
            }
            Color initCol = (Color)fld.getData("scoutInitialBackground");
            Color c = this.getEnvironment().getColor(scoutColor);
            if (c == null) {
                c = initCol;
            }
            fld.setBackground(c);
            for (MultilineRadioButton b : this.m_swtRadioButtons) {
                b.setBackground(c);
            }
        }
    }

    private class P_RadioButtonComposite
    extends Composite {
        public P_RadioButtonComposite(Composite parent) {
            super(parent, 0);
        }

        protected void checkSubclass() {
        }

        public boolean setFocus() {
            for (MultilineRadioButton b : SwtScoutRadioButtonGroup.this.m_swtRadioButtons) {
                if (!b.getSelection()) continue;
                return b.getParent().setFocus();
            }
            return super.setFocus();
        }
    }

    private class P_SwtButtonListener
    implements Listener {
        private P_SwtButtonListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    if (!(event.widget instanceof MultilineRadioButton)) break;
                    MultilineRadioButton button = (MultilineRadioButton)event.widget;
                    this.handleSelectionChanged(button);
                    break;
                }
                case 1: {
                    this.handleKeyDown(event);
                }
            }
        }

        private void handleSelectionChanged(MultilineRadioButton selectedButton) {
            SwtScoutRadioButtonGroup.this.getSwtField().setTabList(new Control[]{selectedButton.getParent().getParent()});
        }

        private void handleKeyDown(Event event) {
            int index = SwtScoutRadioButtonGroup.this.m_swtRadioButtons.indexOf(event.widget);
            if (index < 0) {
                return;
            }
            switch (event.keyCode) {
                case 0x1000002: 
                case 0x1000004: {
                    this.selectNextPossibleRadioButton(index);
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    this.selectPreviousPossibleRadioButton(index);
                    break;
                }
                case 0x1000007: {
                    this.selectFirstPossibleRadioButton();
                    break;
                }
                case 0x1000008: {
                    this.selectLastPossibleRadioButton();
                }
            }
        }

        protected void selectNextPossibleRadioButton(int currentIndex) {
            int i = 1;
            while (i < SwtScoutRadioButtonGroup.this.m_swtRadioButtons.size()) {
                int nextIndex = (currentIndex + i) % SwtScoutRadioButtonGroup.this.m_swtRadioButtons.size();
                if (((MultilineRadioButton)((Object)SwtScoutRadioButtonGroup.this.m_swtRadioButtons.get(nextIndex))).setFocus()) {
                    return;
                }
                ++i;
            }
        }

        protected void selectPreviousPossibleRadioButton(int currentIndex) {
            int i = 1;
            while (i < SwtScoutRadioButtonGroup.this.m_swtRadioButtons.size()) {
                int nextIndex = (currentIndex - i) % SwtScoutRadioButtonGroup.this.m_swtRadioButtons.size();
                if (nextIndex < 0) {
                    nextIndex += SwtScoutRadioButtonGroup.this.m_swtRadioButtons.size();
                }
                if (((MultilineRadioButton)((Object)SwtScoutRadioButtonGroup.this.m_swtRadioButtons.get(nextIndex))).setFocus()) {
                    return;
                }
                ++i;
            }
        }

        protected void selectLastPossibleRadioButton() {
            int i = SwtScoutRadioButtonGroup.this.m_swtRadioButtons.size() - 1;
            while (i >= 0) {
                if (((MultilineRadioButton)((Object)SwtScoutRadioButtonGroup.this.m_swtRadioButtons.get(i))).setFocus()) {
                    return;
                }
                --i;
            }
        }

        protected void selectFirstPossibleRadioButton() {
            for (MultilineRadioButton radioButton : SwtScoutRadioButtonGroup.this.m_swtRadioButtons) {
                if (!radioButton.setFocus()) continue;
                return;
            }
        }
    }
}

