/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.internal.debug.layout.spy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class GridCanvas
extends Canvas {
    public final List<Line> m_lines = new ArrayList<Line>();
    public final List<Bounds> m_bounds = new ArrayList<Bounds>();

    public GridCanvas(Composite parent) {
        super(parent, 0);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int bAlpha;
                for (Bounds b : GridCanvas.this.m_bounds) {
                    Color bForegroud = e.gc.getForeground();
                    bAlpha = e.gc.getAlpha();
                    try {
                        e.gc.setAlpha(255);
                        if (b.color == null) continue;
                        e.gc.setForeground(b.color);
                        e.gc.drawRectangle(b.bounds);
                    }
                    finally {
                        e.gc.setAlpha(bAlpha);
                        e.gc.setForeground(bForegroud);
                    }
                }
                for (Line l : GridCanvas.this.m_lines) {
                    Color backupForegroud = e.gc.getForeground();
                    bAlpha = e.gc.getAlpha();
                    try {
                        e.gc.setAlpha(255);
                        if (l.color == null) continue;
                        e.gc.setForeground(l.color);
                        e.gc.drawLine(l.start.x, l.start.y, l.end.x, l.end.y);
                    }
                    finally {
                        e.gc.setAlpha(bAlpha);
                        e.gc.setForeground(backupForegroud);
                    }
                }
            }
        });
    }

    public void addBounds(Bounds bounds) {
        this.m_bounds.add(bounds);
        this.redraw();
    }

    public void addLine(Line line) {
        this.m_lines.add(line);
        this.redraw();
    }

    public static class Bounds {
        public Rectangle bounds;
        public Color color;

        public Bounds(Rectangle bounds, Color color) {
            this.bounds = bounds;
            this.color = color;
        }
    }

    public static class Line {
        public Point start;
        public Point end;
        public Color color;

        public Line(Point start, Point end, Color color) {
            this.start = start;
            this.end = end;
            this.color = color;
        }
    }
}

