/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.validation;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.ITypeResolver;
import org.eclipse.scout.sdk.sql.binding.FormDataSqlBindingValidator;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.swt.widgets.Shell;

public class FormDataSqlBindingValidateAction
extends AbstractScoutHandler {
    private IType[] m_services;
    private ITypeResolver m_typeresolver;

    public FormDataSqlBindingValidateAction() {
        super(Texts.get((String)"ValidateSqlBindings"), null, null, false, IScoutHandler.Category.DELETE);
    }

    public ITypeResolver getTyperesolver() {
        return this.m_typeresolver;
    }

    public void setTyperesolver(ITypeResolver typeresolver) {
        this.m_typeresolver = typeresolver;
    }

    public void setServices(IType ... services) {
        this.m_services = services;
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        Job j = new Job("Validate FormData SQL Bindings"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    new FormDataSqlBindingValidator(FormDataSqlBindingValidateAction.this.getServices()).run(monitor);
                }
                catch (Exception e) {
                    ScoutSdkUi.logError("could not execute formdata sql binding validation.", e);
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        return null;
    }

    public IType[] getServices() {
        if (this.m_services != null) {
            return this.m_services;
        }
        if (this.m_typeresolver != null) {
            return this.m_typeresolver.getTypes();
        }
        return new IType[0];
    }
}

