/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.classid;

import java.util.LinkedList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.classid.ClassIdValidationJob;
import org.eclipse.scout.sdk.extensions.classidgenerators.ClassIdGenerationContext;
import org.eclipse.scout.sdk.extensions.classidgenerators.ClassIdGenerators;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.annotation.AnnotationNewOperation;
import org.eclipse.scout.sdk.sourcebuilder.annotation.AnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.ui.extensions.quickassist.ClassIdDocumentationSupport;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IMarkerResolution;

public class ClassIdDuplicateResolution
implements IMarkerResolution {
    private final IAnnotation m_annotation;

    public ClassIdDuplicateResolution(IAnnotation annotation) {
        this.m_annotation = annotation;
    }

    public String getLabel() {
        return Texts.get((String)"UpdateWithNewClassIdValue");
    }

    public void run(final IMarker marker) {
        IType parent = (IType)this.m_annotation.getAncestor(7);
        if (TypeUtility.exists((IJavaElement)parent)) {
            ClassIdDocumentationSupport support = new ClassIdDocumentationSupport(parent);
            INlsEntry nlsEntry = support.getNlsEntry();
            boolean migrateDocumentation = false;
            boolean doMigration = true;
            if (nlsEntry != null) {
                MessageBox msgbox = new MessageBox(ScoutSdkUi.getShell(), 452);
                msgbox.setText(Texts.get((String)"KeepAssignedDocumentation"));
                msgbox.setMessage(Texts.get((String)"ThisClassIdHasADocumentationEntryAssigned"));
                int answer = msgbox.open();
                doMigration = answer != 256;
                migrateDocumentation = answer == 64;
            }
            LinkedList<IOperation> ops = new LinkedList<IOperation>();
            if (doMigration) {
                String newId = ClassIdGenerators.generateNewId((ClassIdGenerationContext)new ClassIdGenerationContext(parent));
                ops.add(this.createUpdateAnnotationInJavaSourceOperation(parent, newId));
                if (migrateDocumentation) {
                    ops.add(this.createUpdateClassIdInDocumentationOperation(nlsEntry, newId));
                }
            }
            if (!ops.isEmpty()) {
                OperationJob j = new OperationJob(ops);
                j.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        try {
                            marker.delete();
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        ClassIdValidationJob.executeAsync((long)0L);
                    }
                });
                j.schedule();
            }
        }
    }

    private IOperation createUpdateClassIdInDocumentationOperation(final INlsEntry nlsEntry, final String newId) {
        return new IOperation(){

            public void validate() throws IllegalArgumentException {
            }

            public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
                nlsEntry.getProject().updateKey(nlsEntry, newId, monitor);
            }

            public String getOperationName() {
                return "Update NLS Key to new ClassId";
            }
        };
    }

    private IOperation createUpdateAnnotationInJavaSourceOperation(IType annotationOwner, String newId) {
        return new AnnotationNewOperation(AnnotationSourceBuilderFactory.createClassIdAnnotation((String)newId), (IMember)annotationOwner);
    }
}

