/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RenameConfirmationDialog
extends TitleAreaDialog {
    private final String m_title;
    private final String m_message;
    private StyledTextField m_typeNameField;
    private Set<String> m_notAllowedNames;
    private String m_typeName;

    public RenameConfirmationDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.m_title = title;
        this.m_message = message;
        this.setNotAllowedNames(new HashSet<String>());
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.m_title != null) {
            newShell.setText(this.m_title);
        }
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite rootPane = new Composite(parent, 0);
        this.m_typeNameField = new StyledTextField(rootPane, Texts.get((String)"TypeName"));
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameConfirmationDialog.this.m_typeName = RenameConfirmationDialog.this.m_typeNameField.getText();
                RenameConfirmationDialog.this.revalidate();
            }
        });
        rootPane.setLayoutData((Object)new GridData(768));
        rootPane.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.setMessage(this.m_message);
        return rootPane;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.revalidate();
        return contents;
    }

    protected void revalidate() {
        if (this.getNotAllowedNames().contains(this.m_typeNameField.getText())) {
            this.getOkButton().setEnabled(false);
            this.setMessage(Texts.get((String)"NameAlreadyInUse"), 3);
        } else {
            this.getOkButton().setEnabled(true);
            this.setMessage(this.m_message);
        }
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
        if (this.getContents() != null && !this.getContents().isDisposed()) {
            this.m_typeNameField.setText(typeName);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setNotAllowedNames(Set<String> notAllowedNames) {
        this.m_notAllowedNames = notAllowedNames;
        if (this.getContents() != null && !this.getContents().isDisposed()) {
            this.revalidate();
        }
    }

    public Set<String> getNotAllowedNames() {
        return this.m_notAllowedNames;
    }
}

