/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.javacode;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EntityTextField
extends Composite {
    private final int m_labelPercentage;
    private final IScoutBundle m_project;
    private StyledText m_text;
    private Label m_label;
    private P_EntityContentProvider m_contentProvider;
    private ContentProposalAdapter m_proposalAdapter;

    public EntityTextField(Composite parent, String labelName, int labelPercentage, IScoutBundle p) {
        super(parent, 0);
        this.m_labelPercentage = labelPercentage;
        this.m_project = p;
        this.setLayout((Layout)new FormLayout());
        this.createContent(this);
        this.setLabelText(labelName);
    }

    protected void createContent(Composite parent) {
        this.m_label = new Label(parent, 0);
        this.m_label.setAlignment(131072);
        this.m_text = new StyledText(parent, 2052);
        this.m_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!EntityTextField.this.getStatus().isOK()) {
                    EntityTextField.this.m_text.setForeground(EntityTextField.this.m_text.getDisplay().getSystemColor(3));
                } else {
                    EntityTextField.this.m_text.setForeground(null);
                }
            }
        });
        ControlDecoration deco = new ControlDecoration((Control)this.m_text, 16512);
        deco.setImage(ScoutSdkUi.getImage("content_assist_cue.gif"));
        this.m_contentProvider = new P_EntityContentProvider();
        this.m_proposalAdapter = new ContentProposalAdapter((Control)this.m_text, (IControlContentAdapter)this.m_contentProvider, (IContentProposalProvider)this.m_contentProvider, KeyStroke.getInstance((int)262144, (int)32), null);
        this.m_proposalAdapter.setLabelProvider((ILabelProvider)this.m_contentProvider);
        this.m_proposalAdapter.setProposalAcceptanceStyle(2);
        this.m_proposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                int pos = EntityTextField.this.m_text.getCaretOffset();
                String val = EntityTextField.this.m_proposalAdapter.getLabelProvider().getText((Object)proposal);
                if (StringUtility.hasText((String)val)) {
                    pos = val.length();
                }
                EntityTextField.this.m_text.setCaretOffset(pos);
            }
        });
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(this.getLabelPercentage(), 0);
        labelData.bottom = new FormAttachment(100, 0);
        this.m_label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)this.m_label, 5);
        textData.right = new FormAttachment(100, 0);
        textData.bottom = new FormAttachment(100, 0);
        this.m_text.setLayoutData((Object)textData);
    }

    public void setLabelText(String text) {
        this.m_label.setText(text);
    }

    public String getLabelText() {
        return this.m_label.getText();
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        this.m_text.setText(s);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_text.setEnabled(enabled);
    }

    public IStatus getStatus() {
        return ScoutUtility.validatePackageName((String)this.m_text.getText());
    }

    public void addModifyListener(ModifyListener listener) {
        this.m_text.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.m_text.removeModifyListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.m_text.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.m_text.removeFocusListener(listener);
    }

    public int getLabelPercentage() {
        return this.m_labelPercentage;
    }

    private class P_EntityContentProvider
    extends LabelProvider
    implements IContentProposalProvider,
    IControlContentAdapter {
        private P_EntityContentProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            String searchString = null;
            searchString = !StringUtility.hasText((String)contents) ? "*" : String.valueOf(contents.substring(0, position).trim()) + "*";
            Set<P_EntityProposal> entities = this.getAllEntities();
            Iterator<P_EntityProposal> iterator = entities.iterator();
            while (iterator.hasNext()) {
                P_EntityProposal candidate = iterator.next();
                if (SearchPattern.getMatchingRegions((String)searchString, (String)candidate.m_content, (int)2) != null) continue;
                iterator.remove();
            }
            return entities.toArray(new IContentProposal[entities.size()]);
        }

        private Set<P_EntityProposal> getAllEntities() {
            TreeSet<P_EntityProposal> ret = new TreeSet<P_EntityProposal>();
            try {
                String[] entities;
                String[] stringArray = entities = ScoutUtility.getEntities((IScoutBundle)EntityTextField.this.m_project);
                int n = entities.length;
                int n2 = 0;
                while (n2 < n) {
                    String e = stringArray[n2];
                    ret.add(new P_EntityProposal(e));
                    ++n2;
                }
            }
            catch (JavaModelException e1) {
                ScoutSdkUi.logError("Error while calculating the entity proposals", e1);
            }
            return ret;
        }

        public Image getImage(Object element) {
            return ScoutSdkUi.getImage("package_obj.gif");
        }

        public String getText(Object element) {
            return ((IContentProposal)element).getLabel();
        }

        public void setControlContents(Control control, String contents, int cursorPosition) {
            EntityTextField.this.m_text.setText(contents);
        }

        public void insertControlContents(Control control, String contents, int cursorPosition) {
            EntityTextField.this.m_text.setText(contents);
        }

        public String getControlContents(Control control) {
            return EntityTextField.this.m_text.getText();
        }

        public int getCursorPosition(Control control) {
            return EntityTextField.this.m_text.getCaretOffset();
        }

        public Rectangle getInsertionBounds(Control control) {
            Point caretOrigin = EntityTextField.this.m_text.getCaret().getLocation();
            return new Rectangle(caretOrigin.x, caretOrigin.y, 1, EntityTextField.this.m_text.getLineHeight());
        }

        public void setCursorPosition(Control control, int index) {
            EntityTextField.this.m_text.setCaretOffset(index);
        }
    }

    private static class P_EntityProposal
    implements IContentProposal,
    Comparable<P_EntityProposal> {
        private String m_content;

        private P_EntityProposal(String c) {
            this.m_content = c;
        }

        public String getContent() {
            return this.m_content;
        }

        public int getCursorPosition() {
            return 0;
        }

        public String getLabel() {
            return this.m_content;
        }

        public String getDescription() {
            return null;
        }

        public int hashCode() {
            return this.m_content.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof P_EntityProposal) {
                return this.m_content.equals(((P_EntityProposal)obj).m_content);
            }
            return false;
        }

        @Override
        public int compareTo(P_EntityProposal o) {
            return this.m_content.compareTo(o.m_content);
        }
    }
}

