/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.dialog.workingset;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.dialog.workingset.NewScoutWorkingSetDialog;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerSettingsSupport;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleComparators;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ConfigureScoutWorkingSetsDialog
extends TitleAreaDialog {
    private final OptimisticLock m_lock;
    private SashForm m_sashForm;
    private CheckboxTableViewer m_workingSetsViewer;
    private CheckableTree m_availableBundlesTree;
    private Button m_addWorkingSetButton;
    private Button m_removeWorkingSetButton;
    private Button m_renameWorkingSetButton;
    private Button m_workingSetUpButton;
    private Button m_workingSetDownButton;
    private String m_currentWorkingSet;
    private HashMap<String, IAdaptable[]> m_selection;
    private HashSet<String> m_initialSets;

    public ConfigureScoutWorkingSetsDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setHelpAvailable(false);
        this.m_lock = new OptimisticLock();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Texts.get((String)"ConfigureScoutWorkingSets"));
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.setTitle(Texts.get((String)"ConfigureScoutWorkingSets"));
        this.setMessage(Texts.get((String)"WorkingSetsMsg"));
        return c;
    }

    private String[] getAllWorkingSets() {
        return (String[])this.m_workingSetsViewer.getInput();
    }

    private Set<String> getCheckedWorkingSets() {
        Object[] checked = this.m_workingSetsViewer.getCheckedElements();
        HashSet<String> checkedSets = new HashSet<String>(checked.length);
        Object[] objectArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            checkedSets.add((String)o);
            ++n2;
        }
        return checkedSets;
    }

    private IAdaptable[] getSelectionFor(String workingSet) {
        return this.m_selection.get(workingSet);
    }

    protected Control createDialogArea(Composite parent) {
        this.m_sashForm = new SashForm(parent, 256);
        this.m_sashForm.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        this.m_sashForm.setLayoutData((Object)gd);
        this.createWorkingSetList((Composite)this.m_sashForm);
        this.createWorkingSetContent((Composite)this.m_sashForm);
        String[] sets = this.getAllWorkingSets();
        if (sets.length > 0) {
            this.m_workingSetsViewer.setSelection((ISelection)new StructuredSelection((Object)sets[0]), true);
            this.handleWorkingSetSelectionChanged(sets[0]);
        } else {
            this.handleWorkingSetSelectionChanged(null);
        }
        return this.m_sashForm;
    }

    private void handleWorkingSetSelectionChanged(String set) {
        try {
            boolean isCustomWorkingSetSelected;
            this.m_lock.acquire();
            this.m_currentWorkingSet = set;
            if (set != null) {
                ITreeNode[] checked = TreeUtility.findNodes(this.m_availableBundlesTree.getRootNode(), NodeFilters.getByData(this.getSelectionFor(set)));
                this.m_availableBundlesTree.setChecked(checked);
            }
            ITreeNode[] iTreeNodeArray = TreeUtility.findNodes(this.m_availableBundlesTree.getRootNode(), NodeFilters.getAcceptAll());
            int n = iTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode n3 = iTreeNodeArray[n2];
                if (n3 != this.m_availableBundlesTree.getRootNode()) {
                    n3.setVisible(set != null);
                }
                ++n2;
            }
            this.m_availableBundlesTree.getTreeViewer().refresh();
            boolean bl = isCustomWorkingSetSelected = set != null && !"Other Projects".equals(set);
            if (this.m_removeWorkingSetButton != null && !this.m_removeWorkingSetButton.isDisposed()) {
                this.m_removeWorkingSetButton.setEnabled(isCustomWorkingSetSelected);
            }
            if (this.m_renameWorkingSetButton != null && !this.m_renameWorkingSetButton.isDisposed()) {
                this.m_renameWorkingSetButton.setEnabled(isCustomWorkingSetSelected);
            }
            String[] sets = this.getAllWorkingSets();
            if (this.m_workingSetDownButton != null && !this.m_workingSetDownButton.isDisposed()) {
                this.m_workingSetDownButton.setEnabled(set != null && sets.length > 0 && !set.equals(sets[sets.length - 1]));
            }
            if (this.m_workingSetUpButton != null && !this.m_workingSetUpButton.isDisposed()) {
                this.m_workingSetUpButton.setEnabled(set != null && sets.length > 0 && !sets[0].equals(set));
            }
            if (this.m_availableBundlesTree != null && !this.m_availableBundlesTree.isDisposed()) {
                this.m_availableBundlesTree.setVisible(!"Other Projects".equals(set));
            }
        }
        finally {
            this.m_lock.release();
        }
    }

    private void createWorkingSetList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        IWorkingSet[] scoutWorkingSets = ScoutExplorerSettingsSupport.get().getScoutWorkingSets(true);
        String[] workingSetNames = new String[scoutWorkingSets.length];
        this.m_selection = new HashMap();
        this.m_initialSets = new HashSet(workingSetNames.length);
        int i = 0;
        while (i < workingSetNames.length) {
            workingSetNames[i] = scoutWorkingSets[i].getLabel();
            this.m_selection.put(scoutWorkingSets[i].getLabel(), scoutWorkingSets[i].getElements());
            this.m_initialSets.add(workingSetNames[i]);
            ++i;
        }
        IWorkingSet[] checkedSets = ScoutExplorerSettingsSupport.get().getScoutWorkingSets(false);
        Object[] checkedWorkingSetNames = new String[checkedSets.length];
        int i2 = 0;
        while (i2 < checkedWorkingSetNames.length) {
            checkedWorkingSetNames[i2] = checkedSets[i2].getLabel();
            ++i2;
        }
        Label label = new Label(composite, 0);
        label.setText(String.valueOf(Texts.get((String)"WorkingSets")) + ":");
        this.m_workingSetsViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2050);
        this.m_workingSetsViewer.setContentProvider((IContentProvider)new P_WorkingSetsContentProvider());
        this.m_workingSetsViewer.setLabelProvider((IBaseLabelProvider)new P_WorkingSetsLabelProvider());
        this.m_workingSetsViewer.setComparator(null);
        this.m_workingSetsViewer.setInput((Object)workingSetNames);
        this.m_workingSetsViewer.setCheckedElements(checkedWorkingSetNames);
        this.m_workingSetsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof String) {
                    ConfigureScoutWorkingSetsDialog.this.handleWorkingSetSelectionChanged((String)element);
                }
            }
        });
        Composite buttonContainer = new Composite(composite, 0);
        Composite buttonContainerLeft = new Composite(buttonContainer, 0);
        Composite buttonContainerRight = new Composite(buttonContainer, 0);
        this.m_addWorkingSetButton = new Button(buttonContainerLeft, 0x800008);
        this.m_addWorkingSetButton.setText(String.valueOf(Texts.get((String)"New")) + "...");
        this.m_addWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewScoutWorkingSetDialog d = new NewScoutWorkingSetDialog(ConfigureScoutWorkingSetsDialog.this.getShell(), ConfigureScoutWorkingSetsDialog.this.getAllWorkingSets());
                if (d.open() == 0) {
                    String[] sets = ConfigureScoutWorkingSetsDialog.this.getAllWorkingSets();
                    String[] newSet = new String[sets.length + 1];
                    System.arraycopy(sets, 0, newSet, 0, sets.length);
                    newSet[newSet.length - 1] = d.getWorkingSetName();
                    ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setInput((Object)newSet);
                    ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setSelection((ISelection)new StructuredSelection((Object)d.getWorkingSetName()), true);
                    ConfigureScoutWorkingSetsDialog.this.handleWorkingSetSelectionChanged(d.getWorkingSetName());
                    ConfigureScoutWorkingSetsDialog.this.m_selection.put(d.getWorkingSetName(), new IAdaptable[0]);
                    ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setChecked((Object)d.getWorkingSetName(), true);
                }
            }
        });
        this.m_removeWorkingSetButton = new Button(buttonContainerLeft, 0x800008);
        this.m_removeWorkingSetButton.setText(Texts.get((String)"Remove"));
        this.m_removeWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] sets = ConfigureScoutWorkingSetsDialog.this.getAllWorkingSets();
                String[] newSet = new String[sets.length - 1];
                int i = 0;
                while (i < sets.length) {
                    if (CompareUtility.equals((Object)sets[i], (Object)ConfigureScoutWorkingSetsDialog.this.m_currentWorkingSet)) {
                        System.arraycopy(sets, 0, newSet, 0, i);
                        System.arraycopy(sets, i + 1, newSet, i, sets.length - i - 1);
                        break;
                    }
                    ++i;
                }
                ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setInput((Object)newSet);
                if (newSet.length > 0) {
                    ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setSelection((ISelection)new StructuredSelection((Object)newSet[0]), true);
                    ConfigureScoutWorkingSetsDialog.this.handleWorkingSetSelectionChanged(newSet[0]);
                } else {
                    ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setSelection(null, false);
                    ConfigureScoutWorkingSetsDialog.this.handleWorkingSetSelectionChanged(null);
                }
            }
        });
        this.m_renameWorkingSetButton = new Button(buttonContainerLeft, 0x800008);
        this.m_renameWorkingSetButton.setText(Texts.get((String)"RenameWithPopup"));
        this.m_renameWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewScoutWorkingSetDialog d = new NewScoutWorkingSetDialog(ConfigureScoutWorkingSetsDialog.this.getShell(), ConfigureScoutWorkingSetsDialog.this.getAllWorkingSets()){

                    @Override
                    protected void configureShell(Shell newShell) {
                        super.configureShell(newShell);
                        newShell.setText(Texts.get((String)"RenameScoutWorkingSet"));
                    }
                };
                d.setWorkingSetName(ConfigureScoutWorkingSetsDialog.this.m_currentWorkingSet);
                if (d.open() == 0) {
                    String[] sets = ConfigureScoutWorkingSetsDialog.this.getAllWorkingSets();
                    boolean isChecked = ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.getChecked((Object)ConfigureScoutWorkingSetsDialog.this.m_currentWorkingSet);
                    int i = 0;
                    while (i < sets.length) {
                        if (CompareUtility.equals((Object)sets[i], (Object)ConfigureScoutWorkingSetsDialog.this.m_currentWorkingSet)) {
                            sets[i] = d.getWorkingSetName();
                            break;
                        }
                        ++i;
                    }
                    ConfigureScoutWorkingSetsDialog.this.m_selection.put(d.getWorkingSetName(), (IAdaptable[])ConfigureScoutWorkingSetsDialog.this.m_selection.remove(ConfigureScoutWorkingSetsDialog.this.m_currentWorkingSet));
                    ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setInput((Object)sets);
                    ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setSelection((ISelection)new StructuredSelection((Object)d.getWorkingSetName()), true);
                    ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setChecked((Object)d.getWorkingSetName(), isChecked);
                    ConfigureScoutWorkingSetsDialog.this.handleWorkingSetSelectionChanged(d.getWorkingSetName());
                }
            }
        });
        this.m_workingSetUpButton = new Button(buttonContainerRight, 0x800008);
        this.m_workingSetUpButton.setText(Texts.get((String)"Up"));
        this.m_workingSetUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] sets = ConfigureScoutWorkingSetsDialog.this.getAllWorkingSets();
                String[] newSet = new String[sets.length];
                if (sets.length > 0) {
                    int i = sets.length - 1;
                    while (i >= 0) {
                        if (CompareUtility.equals((Object)sets[i], (Object)ConfigureScoutWorkingSetsDialog.this.m_currentWorkingSet)) {
                            System.arraycopy(sets, 0, newSet, 0, i - 1);
                            newSet[i] = sets[i - 1];
                            newSet[i - 1] = sets[i];
                            if (i >= sets.length - 1) break;
                            System.arraycopy(sets, i + 1, newSet, i + 1, sets.length - i - 1);
                            break;
                        }
                        --i;
                    }
                }
                ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setInput((Object)newSet);
                ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setSelection((ISelection)new StructuredSelection((Object)ConfigureScoutWorkingSetsDialog.this.m_currentWorkingSet), true);
            }
        });
        this.m_workingSetDownButton = new Button(buttonContainerRight, 0x800008);
        this.m_workingSetDownButton.setText(Texts.get((String)"Down"));
        this.m_workingSetDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] sets = ConfigureScoutWorkingSetsDialog.this.getAllWorkingSets();
                String[] newSet = new String[sets.length];
                if (sets.length > 0) {
                    int i = 0;
                    while (i < sets.length) {
                        if (CompareUtility.equals((Object)sets[i], (Object)ConfigureScoutWorkingSetsDialog.this.m_currentWorkingSet)) {
                            System.arraycopy(sets, 0, newSet, 0, i);
                            newSet[i] = sets[i + 1];
                            newSet[i + 1] = sets[i];
                            System.arraycopy(sets, i + 2, newSet, i + 2, sets.length - i - 2);
                            break;
                        }
                        ++i;
                    }
                }
                ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setInput((Object)newSet);
                ConfigureScoutWorkingSetsDialog.this.m_workingSetsViewer.setSelection((ISelection)new StructuredSelection((Object)ConfigureScoutWorkingSetsDialog.this.m_currentWorkingSet), true);
            }
        });
        GridLayout layout = new GridLayout();
        layout.marginWidth = 8;
        layout.marginHeight = 8;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        GridLayout l = new GridLayout(2, true);
        l.verticalSpacing = 0;
        l.horizontalSpacing = 0;
        l.marginHeight = 0;
        l.marginWidth = 0;
        buttonContainer.setLayout((Layout)l);
        l = new GridLayout(3, false);
        l.verticalSpacing = 0;
        l.marginHeight = 0;
        l.marginWidth = 0;
        l.horizontalSpacing = 0;
        buttonContainerLeft.setLayout((Layout)l);
        buttonContainerRight.setLayout((Layout)l);
        GridData d = new GridData(4, 128, true, false);
        buttonContainer.setLayoutData((Object)d);
        d = new GridData(131072, 128, true, false);
        buttonContainerRight.setLayoutData((Object)d);
        gd = new GridData(1808);
        gd.heightHint = 400;
        this.m_workingSetsViewer.getControl().setLayoutData((Object)gd);
    }

    private ITreeNode createTree() {
        IScoutBundle[] allBundles;
        TreeNode rootNode = new TreeNode("root", "root");
        rootNode.setVisible(false);
        IScoutBundle[] iScoutBundleArray = allBundles = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getAllBundlesFilter(), ScoutBundleComparators.getSymbolicNameAscComparator());
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle b = iScoutBundleArray[n2];
            ITreeNode bundleNode = TreeUtility.createBundleTreeNode(rootNode, b);
            if (bundleNode != null) {
                bundleNode.setOrderNr(0);
                bundleNode.setCheckable(true);
            }
            ++n2;
        }
        return rootNode;
    }

    private void createWorkingSetContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label label = new Label(composite, 0);
        label.setText(String.valueOf(Texts.get((String)"AvailableBundles")) + ":");
        this.m_availableBundlesTree = new CheckableTree(composite, this.createTree());
        this.m_availableBundlesTree.setDragDetect(false);
        this.m_availableBundlesTree.addCheckSelectionListener(new ICheckStateListener(){

            @Override
            public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                if (!ConfigureScoutWorkingSetsDialog.this.m_lock.isAcquired()) {
                    IAdaptable[] newElements;
                    IAdaptable changedBundle = (IAdaptable)node.getData();
                    IAdaptable[] old = ConfigureScoutWorkingSetsDialog.this.getSelectionFor(ConfigureScoutWorkingSetsDialog.this.m_currentWorkingSet);
                    if (checkState) {
                        newElements = new IAdaptable[old.length + 1];
                        System.arraycopy(old, 0, newElements, 0, old.length);
                        newElements[newElements.length - 1] = changedBundle;
                    } else {
                        newElements = new IAdaptable[old.length - 1];
                        int pos = 0;
                        IAdaptable[] iAdaptableArray = old;
                        int n = old.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IAdaptable existing = iAdaptableArray[n2];
                            if (CompareUtility.notEquals((Object)existing, (Object)changedBundle)) {
                                newElements[pos++] = existing;
                            }
                            ++n2;
                        }
                    }
                    ConfigureScoutWorkingSetsDialog.this.m_selection.put(ConfigureScoutWorkingSetsDialog.this.m_currentWorkingSet, newElements);
                }
            }
        });
        GridLayout layout = new GridLayout();
        layout.marginWidth = 8;
        layout.marginHeight = 8;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 500;
        this.m_availableBundlesTree.setLayoutData(gd);
        gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
    }

    protected void okPressed() {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] existings = ScoutExplorerSettingsSupport.get().getScoutWorkingSets(true);
        Set<String> visibleSets = this.getCheckedWorkingSets();
        HashSet<IWorkingSet> hiddenSets = new HashSet<IWorkingSet>();
        LinkedHashSet<IWorkingSet> setOrder = new LinkedHashSet<IWorkingSet>();
        String[] stringArray = this.getAllWorkingSets();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String workingSet = stringArray[n2];
            IWorkingSet currentSet = null;
            IWorkingSet[] iWorkingSetArray = existings;
            int n3 = existings.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkingSet s = iWorkingSetArray[n4];
                if (workingSet.equals(s.getLabel())) {
                    currentSet = s;
                    break;
                }
                ++n4;
            }
            if (currentSet == null) {
                currentSet = workingSetManager.createWorkingSet(workingSet, this.getSelectionFor(workingSet));
                currentSet.setId("org.eclipse.scout.sdk.ui.workingSet");
                workingSetManager.addWorkingSet(currentSet);
            } else {
                currentSet.setName(workingSet);
                currentSet.setElements(this.getSelectionFor(workingSet));
            }
            this.m_initialSets.remove(workingSet);
            if (!visibleSets.contains(currentSet.getLabel())) {
                hiddenSets.add(currentSet);
            }
            setOrder.add(currentSet);
            ++n2;
        }
        for (String name : this.m_initialSets) {
            workingSetManager.removeWorkingSet(workingSetManager.getWorkingSet(name));
        }
        ScoutExplorerSettingsSupport.get().setHiddenScoutWorkingSets(hiddenSets.toArray(new IWorkingSet[hiddenSets.size()]));
        ScoutExplorerSettingsSupport.get().setWorkingSetsOrder(setOrder.toArray(new IWorkingSet[setOrder.size()]));
        super.okPressed();
    }

    private class P_WorkingSetsContentProvider
    implements ITreeContentProvider {
        private P_WorkingSetsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class P_WorkingSetsLabelProvider
    extends LabelProvider {
        private P_WorkingSetsLabelProvider() {
        }

        public Image getImage(Object element) {
            return ScoutSdkUi.getImage(ScoutSdkUi.getImageDescriptor("scoutWorkingSet.png"));
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

