/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.bundle;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.extensions.bundle.INewScoutBundleHandler;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizard;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;

public class ClientScoutBundleExtension
implements INewScoutBundleHandler {
    public static final String ID = "org.eclipse.scout.sdk.ui.ClientBundle";

    @Override
    public void init(IScoutProjectWizard wizard, ScoutBundleUiExtension extension) {
        IScoutBundle selected = wizard.getScoutProject();
        boolean clientAvailable = selected == null || selected.getType().equals("CLIENT") || selected.getType().equals("SHARED");
        wizard.getProjectWizardPage().setBundleNodeAvailable(clientAvailable, clientAvailable, ID);
    }

    @Override
    public IStatus getStatus(IScoutProjectWizard wizard) {
        IScoutBundle selected = wizard.getScoutProject();
        if (selected == null && !wizard.getProjectWizardPage().hasSelectedBundle("SHARED")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoClientWithoutAShared"));
        }
        return Status.OK_STATUS;
    }

    @Override
    public void bundleSelectionChanged(IScoutProjectWizard wizard, boolean selected) {
    }

    @Override
    public void putProperties(IScoutProjectWizard wizard, PropertyMap properties) {
        IScoutBundle client;
        IScoutBundle selected = wizard.getScoutProject();
        if (selected != null && (client = selected.getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}), true)) != null && client.getJavaProject() != null) {
            properties.setProperty("BUNDLE_CLIENT_NAME", (Object)client.getProject().getName());
            ((List)properties.getProperty("CREATED_BUNDLES", List.class)).add(client.getJavaProject());
        }
    }
}

