/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.ITypeResolver;
import org.eclipse.scout.sdk.operation.util.wellform.WellformClientBundleOperation;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.OrganizeAllImportsAction;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.ClassIdNewAction;
import org.eclipse.scout.sdk.ui.action.create.ScoutBundleNewAction;
import org.eclipse.scout.sdk.ui.action.dto.MultipleUpdateFormDataAction;
import org.eclipse.scout.sdk.ui.action.dto.TypeResolverPageDataAction;
import org.eclipse.scout.sdk.ui.action.export.ExportScoutProjectAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerSettingsSupport;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNode;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNodeGroup;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.dto.formdata.ScoutBundlesUpdateFormDataOperation;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class BundleNodeGroupTablePage
extends AbstractPage {
    private ScoutBundleNodeGroup m_group;

    public BundleNodeGroupTablePage(AbstractPage parentPage, ScoutBundleNodeGroup group) {
        this.m_group = group;
        this.setParent(parentPage);
        this.setName(group.getGroupName());
        ImageDescriptor icon = ScoutSdkUi.getImageDescriptor("projectGroup.png");
        if (group.isBinary()) {
            icon = ScoutSdkUi.getImageDescriptor(icon, "binary_decoration.png", 2);
        }
        this.setImageDescriptor(icon);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.BundleNodeGroupTablePage";
    }

    @Override
    public int getOrder() {
        return 10000;
    }

    @Override
    public IScoutBundle getScoutBundle() {
        return this.m_group.getDefiningBundle().getScoutBundle();
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{OrganizeAllImportsAction.class, MultipleUpdateFormDataAction.class, TypeResolverPageDataAction.class, FormDataSqlBindingValidateAction.class, ExportScoutProjectAction.class, ScoutBundleNewAction.class, WellformAction.class, ClassIdNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof OrganizeAllImportsAction) {
            ((OrganizeAllImportsAction)menu).setScoutProject(this.getScoutBundle());
        } else if (menu instanceof MultipleUpdateFormDataAction) {
            ((MultipleUpdateFormDataAction)menu).setOperation((IOperation)new ScoutBundlesUpdateFormDataOperation(this.getScoutBundle()));
        } else if (menu instanceof FormDataSqlBindingValidateAction) {
            ((FormDataSqlBindingValidateAction)menu).setTyperesolver(new ITypeResolver(){

                public IType[] getTypes() {
                    return BundleNodeGroupTablePage.this.resolveServices();
                }
            });
        } else if (menu instanceof ClassIdNewAction) {
            ((ClassIdNewAction)menu).setScoutBundle(this.getScoutBundle());
        } else if (menu instanceof ExportScoutProjectAction) {
            ((ExportScoutProjectAction)menu).setScoutProject(this.getScoutBundle());
        } else if (menu instanceof ScoutBundleNewAction) {
            ((ScoutBundleNewAction)menu).setScoutProject(this.getScoutBundle());
        } else if (menu instanceof TypeResolverPageDataAction) {
            ((TypeResolverPageDataAction)menu).init(new ITypeResolver(){

                public IType[] getTypes() {
                    IType iPageWithTable = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable");
                    IPrimaryTypeTypeHierarchy pageWithTableHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iPageWithTable);
                    ArrayList bundles = new ArrayList();
                    BundleNodeGroupTablePage.this.collectBundlesRec(BundleNodeGroupTablePage.this.m_group, bundles);
                    return pageWithTableHierarchy.getAllSubtypes(iPageWithTable, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])bundles.toArray(new IScoutBundle[bundles.size()])));
                }
            }, this.getScoutBundle());
        } else if (menu instanceof WellformAction) {
            WellformAction action = (WellformAction)menu;
            ArrayList<IScoutBundle> bundles = new ArrayList<IScoutBundle>();
            this.collectBundlesRec(this.m_group, bundles);
            action.setOperation((IOperation)new WellformClientBundleOperation(bundles.toArray(new IScoutBundle[bundles.size()])));
            action.init(this.getScoutBundle());
        }
    }

    private void collectBundlesRec(ScoutBundleNodeGroup group, List<IScoutBundle> collector) {
        for (ScoutBundleNode b : this.m_group.getChildBundles()) {
            collector.add(b.getScoutBundle());
        }
        for (ScoutBundleNodeGroup childGroup : group.getChildGroups()) {
            this.collectBundlesRec(childGroup, collector);
        }
    }

    protected IType[] resolveServices() {
        IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
        IPrimaryTypeTypeHierarchy serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iService);
        IScoutBundle[] serverBundles = this.getScoutBundle().getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SERVER"}), true);
        IType[] services = serviceHierarchy.getAllSubtypes(iService, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])serverBundles));
        return services;
    }

    @Override
    public void loadChildrenImpl() {
        for (ScoutBundleNode b : this.m_group.getChildBundles()) {
            b.createBundlePage(this);
        }
        if (ScoutExplorerSettingsSupport.BundlePresentation.Grouped.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
            Object[] childGroups = this.m_group.getChildGroups().toArray(new ScoutBundleNodeGroup[this.m_group.getChildGroups().size()]);
            Arrays.sort(childGroups);
            Object[] objectArray = childGroups;
            int n = childGroups.length;
            int n2 = 0;
            while (n2 < n) {
                Object childGroup = objectArray[n2];
                new BundleNodeGroupTablePage(this, (ScoutBundleNodeGroup)childGroup);
                ++n2;
            }
        }
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash += 31 * hash + this.m_group.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (!equals) {
            return false;
        }
        if (!(obj instanceof BundleNodeGroupTablePage)) {
            return false;
        }
        return CompareUtility.equals((Object)this.m_group, (Object)((BundleNodeGroupTablePage)obj).m_group);
    }
}

