/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.ITypeResolver;
import org.eclipse.scout.sdk.operation.util.wellform.WellformFormsOperation;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.FormNewAction;
import org.eclipse.scout.sdk.ui.action.dto.TypeResolverFormDataAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class FormTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_formHierarchy;

    public FormTablePage(AbstractPage parent) {
        this.setName(Texts.get((String)"FormTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("forms.png"));
        this.setParent(parent);
    }

    @Override
    public void unloadPage() {
        if (this.m_formHierarchy != null) {
            this.m_formHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_formHierarchy != null) {
            this.m_formHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.FormTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveForms();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            new FormNodePage(this, t);
            ++n2;
        }
    }

    protected IType[] resolveForms() {
        IType iForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
        IType iSearchForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
        if (this.m_formHierarchy == null) {
            this.m_formHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iForm);
            this.m_formHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IScoutBundle sb = this.getScoutBundle();
        IType[] searchForms = this.m_formHierarchy.getAllSubtypes(iSearchForm, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{sb}));
        IType[] allForms = this.m_formHierarchy.getAllSubtypes(iForm, TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{sb}), TypeFilters.getNotInTypes((IType[])searchForms)}), TypeComparators.getTypeNameComparator());
        return allForms;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{WellformAction.class, FormNewAction.class, TypeResolverFormDataAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof WellformAction) {
            WellformAction action = (WellformAction)menu;
            action.setOperation((IOperation)new WellformFormsOperation(this.getScoutBundle()));
            action.init(this.getScoutBundle());
            action.setLabel(Texts.get((String)"WellformAllForms"));
        } else if (menu instanceof FormNewAction) {
            ((FormNewAction)menu).setScoutBundle(this.getScoutBundle());
        } else if (menu instanceof TypeResolverFormDataAction) {
            ((TypeResolverFormDataAction)menu).init(new ITypeResolver(){

                public IType[] getTypes() {
                    return FormTablePage.this.resolveForms();
                }
            }, this.getScoutBundle());
        }
    }
}

