/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.multi;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.multi.AbstractMultiValuePresenter;
import org.eclipse.scout.sdk.ui.view.properties.presenter.util.MethodBean;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethodSet;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.IntegerPropertySourceParser;
import org.eclipse.swt.widgets.Composite;

public class MultiIntegerPresenter
extends AbstractMultiValuePresenter<Integer> {
    public MultiIntegerPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, "[-+0-9\\'eEinf]*");
    }

    @Override
    protected void init(ConfigurationMethodSet methodSet) throws CoreException {
        super.init(methodSet);
        Collection methodBeans = this.getMethodBeans();
        if (!MultiIntegerPresenter.allEqual(methodBeans)) {
            this.getTextComponent().setText("###");
        } else {
            this.getTextComponent().setText(this.formatDisplayValue((Integer)methodBeans.iterator().next().getCurrentSourceValue()));
        }
    }

    @Override
    protected int getTextAlignment() {
        return 131072;
    }

    @Override
    protected String formatSourceValue(Integer value) throws CoreException {
        if (value == null) {
            return "null";
        }
        if (value == Integer.MAX_VALUE) {
            return "Integer.MAX_VALUE";
        }
        if (value == Integer.MIN_VALUE) {
            return "Integer.MIN_VALUE";
        }
        return DecimalFormat.getNumberInstance().format(value);
    }

    @Override
    protected String formatDisplayValue(Integer value) throws CoreException {
        if (value == null) {
            return "";
        }
        if (value == Integer.MAX_VALUE) {
            return "inf";
        }
        if (value == -2147483647) {
            return "-inf";
        }
        return DecimalFormat.getNumberInstance().format(value);
    }

    @Override
    protected Integer parseSourceInput(String value, ConfigurationMethod method) throws CoreException {
        Integer d = PropertyMethodSourceUtility.parseReturnParameterInteger((String)value, (IMethod)method.peekMethod(), (ITypeHierarchy)method.getSuperTypeHierarchy());
        return d;
    }

    @Override
    protected Integer parseDisplayInput(String input) throws CoreException {
        Integer d = PropertyMethodSourceUtility.parseReturnParameterInteger((String)input);
        return d;
    }

    @Override
    protected synchronized void storeMethods(Collection<MethodBean<Integer>> beans, Integer value) {
        ArrayList<ConfigPropertyUpdateOperation> list = new ArrayList<ConfigPropertyUpdateOperation>(beans.size());
        for (MethodBean<Integer> bean : beans) {
            ConfigurationMethod method = bean.getMethod();
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(method, (IPropertySourceParser)new IntegerPropertySourceParser());
            updateOp.setValue((Object)value);
            list.add(updateOp);
        }
        new OperationJob(list).schedule();
    }
}

