/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.sdk.icon.IIconProvider;
import org.eclipse.scout.sdk.icon.ScoutIconDesc;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.icon.IconContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.icon.IconLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.IconSourcePropertyParser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class IconPresenter
extends AbstractMethodPresenter {
    private Label m_currentIconPresenter;
    private ProposalTextField m_proposalField;
    private IIconProvider m_iconProvider;
    private ScoutIconDesc m_defaultIcon;
    private ScoutIconDesc m_currentSourceIcon;
    private final OptimisticLock m_storeValueLock;
    private final IconSourcePropertyParser m_parser = new IconSourcePropertyParser();

    public IconPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
        this.m_storeValueLock = new OptimisticLock();
    }

    @Override
    protected Control createContent(Composite container) {
        Composite rootPane = this.getToolkit().createComposite(container);
        this.m_currentIconPresenter = this.getToolkit().createLabel(rootPane, "", 0x800000);
        this.m_proposalField = this.getToolkit().createProposalField(rootPane, 1024);
        this.toolkitAdapt((Control)this.m_proposalField);
        this.m_proposalField.setLabelProvider((IBaseLabelProvider)new IconLabelProvider(this.m_proposalField.getDisplay()));
        this.m_proposalField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                IconPresenter.this.handleProposalAccepted(event);
            }
        });
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.horizontalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.verticalSpacing = 0;
        rootPane.setLayout((Layout)gLayout);
        this.m_proposalField.setLayoutData(new GridData(768));
        GridData gData = new GridData(22, 22);
        gData.exclude = true;
        this.m_currentIconPresenter.setLayoutData((Object)gData);
        return rootPane;
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        if (method == null) {
            return;
        }
        super.init(method);
        IIconProvider newIconProvider = ScoutTypeUtility.findIconProvider((IJavaElement)method.getType());
        if (!CompareUtility.equals((Object)newIconProvider, (Object)this.m_iconProvider)) {
            this.m_iconProvider = newIconProvider;
            this.m_parser.setIconProvider(this.m_iconProvider);
            this.m_proposalField.setContentProvider(new IconContentProvider(this.m_iconProvider, (ILabelProvider)this.m_proposalField.getLabelProvider()));
            this.m_proposalField.setEnabled(this.m_iconProvider != null);
        }
        this.m_defaultIcon = this.parseInput(this.getMethod().computeDefaultValue());
        try {
            this.m_storeValueLock.acquire();
            this.m_currentSourceIcon = this.parseInput(this.getMethod().computeValue());
            this.m_proposalField.acceptProposal(this.m_currentSourceIcon);
            this.updateIcon(this.m_currentSourceIcon);
            this.m_proposalField.setEnabled(true);
        }
        finally {
            this.m_storeValueLock.release();
        }
    }

    public IconSourcePropertyParser getParser() {
        return this.m_parser;
    }

    protected void handleProposalAccepted(ContentProposalEvent event) {
        Object proposal = event.proposal;
        if (proposal == null) {
            this.m_proposalField.setText("");
            this.storeValue(null);
        } else {
            this.storeValue((ScoutIconDesc)proposal);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_proposalField.setEnabled(enabled && this.getIconProvider() != null);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_proposalField.getEnabled() && super.isEnabled();
        }
        return false;
    }

    public IIconProvider getIconProvider() {
        return this.m_iconProvider;
    }

    protected ScoutIconDesc parseInput(String input) throws CoreException {
        return this.getParser().parseSourceValue(input, this.getMethod().peekMethod(), this.getMethod().getSuperTypeHierarchy());
    }

    public ScoutIconDesc getDefaultValue() {
        return this.m_defaultIcon;
    }

    private void updateIcon(ScoutIconDesc newIcon) {
        Image icon = null;
        if (newIcon != null) {
            icon = ((ILabelProvider)this.m_proposalField.getLabelProvider()).getImage((Object)newIcon);
        }
        boolean iconAvailable = icon != null;
        ((GridData)this.m_currentIconPresenter.getLayoutData()).exclude = !iconAvailable;
        this.m_currentIconPresenter.setVisible(iconAvailable);
        this.m_currentIconPresenter.setImage(icon);
        this.getContainer().layout(true, true);
    }

    protected synchronized void storeValue(ScoutIconDesc value) {
        try {
            try {
                if (this.m_storeValueLock.acquire()) {
                    if (value == null) {
                        this.m_proposalField.acceptProposal(this.getDefaultValue());
                        value = this.getDefaultValue();
                    }
                    ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(this.getMethod(), (IPropertySourceParser)this.getParser());
                    updateOp.setValue((Object)value);
                    final OperationJob job = new OperationJob(new IOperation[]{updateOp});
                    job.setDebug(true);
                    final ScoutIconDesc finalValue = value;
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            job.removeJobChangeListener((IJobChangeListener)this);
                            IconPresenter.this.getContainer().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IconPresenter.this.updateIcon(finalValue);
                                }
                            });
                        }
                    });
                    job.schedule();
                }
            }
            catch (Exception e) {
                ScoutSdkUi.logError("could not parse default value of method '" + this.getMethod().getMethodName() + "' in type '" + this.getMethod().getType().getFullyQualifiedName() + "'.", e);
                this.m_storeValueLock.release();
            }
        }
        finally {
            this.m_storeValueLock.release();
        }
    }
}

