/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.UiSourceProperty;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.parser.AbstractSourcePropertyParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.IntegerSourcePropertyParser;
import org.eclipse.scout.sdk.workspace.type.config.property.AbstractSourceProperty;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class VerticalAglinmentPresenter
extends AbstractProposalPresenter<AbstractSourceProperty<Integer>> {
    protected static final AbstractSourceProperty<Integer> TOP = new UiSourceProperty<Integer>(-1, "top");
    protected static final AbstractSourceProperty<Integer> CENTER = new UiSourceProperty<Integer>(0, "center");
    protected static final AbstractSourceProperty<Integer> BOTTOM = new UiSourceProperty<Integer>(1, "bottom");
    protected static final List<AbstractSourceProperty<Integer>> PROPOSALS = new ArrayList<AbstractSourceProperty<Integer>>(3);
    private final AbstractSourcePropertyParser<Integer> m_parser = new IntegerSourcePropertyParser(PROPOSALS);

    static {
        PROPOSALS.add(TOP);
        PROPOSALS.add(CENTER);
        PROPOSALS.add(BOTTOM);
    }

    public VerticalAglinmentPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                if (CompareUtility.equals(TOP, (Object)element)) {
                    return ScoutSdkUi.getImage("vertical_top.gif");
                }
                if (CompareUtility.equals(CENTER, (Object)element)) {
                    return ScoutSdkUi.getImage("vertical_center.gif");
                }
                if (CompareUtility.equals(BOTTOM, (Object)element)) {
                    return ScoutSdkUi.getImage("vertical_bottom.gif");
                }
                return ScoutSdkUi.getImage("default.gif");
            }
        };
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        StaticContentProvider provider = new StaticContentProvider((Object[])PROPOSALS.toArray(new UiSourceProperty[PROPOSALS.size()]), (ILabelProvider)labelProvider);
        this.getProposalField().setContentProvider(provider);
    }

    public AbstractSourcePropertyParser<Integer> getParser() {
        return this.m_parser;
    }

    @Override
    protected AbstractSourceProperty<Integer> parseInput(String input) throws CoreException {
        return this.getParser().parseSourceValue(input, this.getMethod().peekMethod(), this.getMethod().getSuperTypeHierarchy());
    }

    @Override
    protected synchronized void storeValue(AbstractSourceProperty<Integer> value) throws CoreException {
        if (value == null) {
            this.getProposalField().acceptProposal(this.getDefaultValue());
            value = (AbstractSourceProperty)this.getDefaultValue();
        }
        try {
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(this.getMethod(), this.getParser());
            updateOp.setValue((Object)value);
            OperationJob job = new OperationJob(new IOperation[]{updateOp});
            job.setDebug(true);
            job.schedule();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not parse default value of method '" + this.getMethod().getMethodName() + "' in type '" + this.getMethod().getType().getFullyQualifiedName() + "'.", e);
        }
    }
}

