/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.operation.sourceedit;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class SourceEditOperation
implements IOperation {
    private TextEdit m_edit;
    private IDocument m_document;
    private Display m_display;

    public SourceEditOperation(TextEdit edit, IDocument document, Display display) {
        this.m_edit = edit;
        this.m_document = document;
        this.m_display = display;
    }

    public String getOperationName() {
        return "Replace source...";
    }

    public void validate() throws IllegalArgumentException {
        if (this.getEdit() == null) {
            throw new IllegalArgumentException("Edit can not be null.");
        }
        if (this.getDocument() == null) {
            throw new IllegalArgumentException("Document can not be null.");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        final Holder exceptionHolder = new Holder(CoreException.class);
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    SourceEditOperation.this.getEdit().apply(SourceEditOperation.this.getDocument());
                }
                catch (MalformedTreeException e) {
                    exceptionHolder.setValue((Object)new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", "Edit could not be applied", (Throwable)e)));
                }
                catch (BadLocationException e) {
                    exceptionHolder.setValue((Object)new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", "Edit could not be applied", (Throwable)e)));
                }
            }
        });
        if (exceptionHolder.getValue() != null) {
            throw (CoreException)((Object)exceptionHolder.getValue());
        }
    }

    public TextEdit getEdit() {
        return this.m_edit;
    }

    public IDocument getDocument() {
        return this.m_document;
    }

    public Display getDisplay() {
        return this.m_display;
    }
}

