/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline;

import java.util.EventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.job.LoadOutlineChildrenJob;
import org.eclipse.scout.sdk.ui.view.outline.IContentProviderListener;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;

public class ViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private boolean m_autoLoadChildren = true;
    private EventListenerList m_listener = new EventListenerList();
    private boolean m_loadSync = false;
    private IPage m_invisibleRootNode;

    public void addContentProviderListener(IContentProviderListener listener) {
        this.m_listener.add(IContentProviderListener.class, (EventListener)listener);
    }

    public void removeContentProviderListener(IContentProviderListener listener) {
        this.m_listener.remove(IContentProviderListener.class, (EventListener)listener);
    }

    private void fireChildrenLoaded(IPage page) {
        IContentProviderListener[] iContentProviderListenerArray = (IContentProviderListener[])this.m_listener.getListeners(IContentProviderListener.class);
        int n = iContentProviderListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContentProviderListener l = iContentProviderListenerArray[n2];
            try {
                l.handleChildrenLoaded(page);
            }
            catch (Exception e) {
                ScoutSdkUi.logError("error during listerner notification.", e);
            }
            ++n2;
        }
    }

    public void setAutoLoadChildren(boolean b) {
        this.m_autoLoadChildren = b;
    }

    public boolean isAutoLoadChildren() {
        return this.m_autoLoadChildren;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.m_invisibleRootNode = (IPage)newInput;
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (this.m_invisibleRootNode != null) {
            return this.m_invisibleRootNode.getChildArray();
        }
        return new Object[0];
    }

    public Object getParent(Object child) {
        if (child instanceof IPage) {
            return ((IPage)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof IPage) {
            final IPage node = (IPage)parent;
            if (this.isAutoLoadChildren() && !node.isChildrenLoaded()) {
                final LoadOutlineChildrenJob job = new LoadOutlineChildrenJob(node);
                if (this.isLoadSync()) {
                    job.run((IProgressMonitor)new NullProgressMonitor());
                } else {
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            job.removeJobChangeListener((IJobChangeListener)this);
                            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ViewContentProvider.this.fireChildrenLoaded(node);
                                }
                            });
                        }
                    });
                    job.schedule();
                    try {
                        job.join(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!job.isDone()) {
                        return new Object[]{Texts.get((String)"Loading")};
                    }
                }
            }
            return node.getChildArray();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof IPage) {
            IPage node = (IPage)parent;
            if (node.isChildrenLoaded()) {
                return node.hasChildren();
            }
            return true;
        }
        return false;
    }

    public void setLoadSync(boolean loadSync) {
        this.m_loadSync = loadSync;
    }

    public boolean isLoadSync() {
        return this.m_loadSync;
    }
}

