/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class InnerTypeOrderChangedPageDirtyListener
implements IJavaResourceChangedListener {
    private final IPage m_page;
    private final IType m_innerTypeSuperType;
    private final IType m_declaringType;

    public InnerTypeOrderChangedPageDirtyListener(IPage page, IType innerTypeSuperType, IType declaringType) {
        this.m_page = page;
        this.m_innerTypeSuperType = innerTypeSuperType;
        this.m_declaringType = declaringType;
    }

    public void handleEvent(JdtEvent event) {
        if (event.getElementType() == 16) {
            if (TypeUtility.exists((IJavaElement)event.getElement())) {
                IAnnotation annotation = (IAnnotation)event.getElement();
                IJavaElement annotationOwner = annotation.getParent();
                ITypeHierarchy superTypeHierarchy = event.getSuperTypeHierarchy();
                if (superTypeHierarchy != null && superTypeHierarchy.contains(this.getInnerTypeSuperType()) && TypeUtility.exists((IJavaElement)annotationOwner) && annotationOwner.getParent().equals(this.getDeclaringType())) {
                    this.getPage().markStructureDirty();
                }
            }
        } else if (event.getElementType() == 7) {
            IType eventType = (IType)event.getElement();
            int i = -1;
            for (IPage p : this.getPage().getChildren()) {
                if (!(p instanceof ITypePage)) continue;
                ++i;
                ITypePage tp = (ITypePage)p;
                if (eventType.equals(tp.getType())) break;
            }
            if (i >= 0) {
                IType[] innerTypesOrdered = ScoutTypeUtility.getInnerTypesOrdered((IType)this.getDeclaringType(), (IType)this.getInnerTypeSuperType());
                if (innerTypesOrdered.length > i) {
                    if (!innerTypesOrdered[i].equals(eventType)) {
                        this.getPage().markStructureDirty();
                    }
                } else {
                    this.getPage().markStructureDirty();
                }
            }
        }
    }

    public IPage getPage() {
        return this.m_page;
    }

    public IType getInnerTypeSuperType() {
        return this.m_innerTypeSuperType;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }
}

