/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages.basic.beanproperty;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.delete.PropertyBeanDeleteAction;
import org.eclipse.scout.sdk.ui.action.rename.PropertyBeansRenameAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.IPropertyBean;

public class BeanPropertyNodePage
extends AbstractPage {
    private final IPropertyBean m_propertyDescriptor;

    public BeanPropertyNodePage(IPage parentPage, IPropertyBean propertyDescriptor) {
        this.m_propertyDescriptor = propertyDescriptor;
        this.setParent(parentPage);
        this.setName(String.valueOf(this.getPropertyDescriptor().getBeanName()) + " (" + Signature.getSignatureSimpleName((String)this.getPropertyDescriptor().getBeanSignature()) + ")");
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("variable.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.BeanPropertyNodePage";
    }

    @Override
    public ImageDescriptor getBaseImageDescriptor() {
        ImageDescriptor imgDesc = JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.field_default_obj.gif");
        if (this.getPropertyDescriptor().getReadMethod() != null) {
            try {
                int flags = this.getPropertyDescriptor().getReadMethod().getFlags();
                if ((flags & 1) != 0) {
                    imgDesc = JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpub_obj.gif");
                } else if ((flags & 4) != 0) {
                    imgDesc = JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpro_obj.gif");
                } else if (false) {
                    imgDesc = JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methdef_obj.gif");
                } else if ((flags & 2) != 0) {
                    imgDesc = JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpri_obj.gif");
                }
            }
            catch (JavaModelException e) {
                ScoutSdkUi.logWarning(e);
            }
        }
        return imgDesc;
    }

    public IPropertyBean getPropertyDescriptor() {
        return this.m_propertyDescriptor;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{PropertyBeansRenameAction.class, PropertyBeanDeleteAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof PropertyBeansRenameAction) {
            ((PropertyBeansRenameAction)menu).setPropertyBeanDescriptors(new IPropertyBean[]{this.getPropertyDescriptor()});
        } else if (menu instanceof PropertyBeanDeleteAction) {
            ((PropertyBeanDeleteAction)menu).setBeanDesc(this.getPropertyDescriptor());
        }
    }
}

