/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import org.eclipse.core.resources.IFile;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.extensions.view.property.ISinglePropertyViewPart;
import org.eclipse.scout.sdk.ui.internal.view.icons.IconsEditor;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.IconNodePage;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.FileOpenLink;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinksPresenterModel;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.LinksPresenter;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.properties.part.AbstractSectionBasedPart;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class IconsPropertyViewPart
extends AbstractSectionBasedPart
implements ISinglePropertyViewPart {
    private static final String SECTION_ID_LINKS = "section.links";
    private IconNodePage m_page;

    @Override
    public void setPage(IPage page) {
        if (!(page instanceof IconNodePage)) {
            throw new IllegalArgumentException("page must extend '" + IconNodePage.class.getName() + "'");
        }
        this.m_page = (IconNodePage)page;
    }

    @Override
    public IconNodePage getPage() {
        return this.m_page;
    }

    @Override
    protected void createSections() {
        ISection linkSection = this.createSection(SECTION_ID_LINKS, Texts.get((String)"Links"));
        this.fillLinkSection(linkSection.getSectionClient());
        super.createSections();
    }

    protected void fillLinkSection(Composite parent) {
        LinksPresenterModel model = new LinksPresenterModel();
        IFile nlsFile = (IFile)this.getPage().getIconsType().getResource();
        if (nlsFile != null && nlsFile.exists()) {
            FileOpenLink link = new FileOpenLink(nlsFile, 10, IconsEditor.ID);
            link.setName(Texts.get((String)"OpenIconsEditor"));
            model.addGlobalLink(link);
        }
        LinksPresenter presenter = new LinksPresenter(this.getFormToolkit(), parent, model);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        presenter.getContainer().setLayoutData((Object)layoutData);
    }
}

