/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractScoutWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractWorkspaceWizard
extends AbstractWizard
implements IWorkspaceWizard {
    public Map<CompositeObject, IOperation> m_performFinishOperations = new TreeMap<CompositeObject, IOperation>();

    public AbstractWorkspaceWizard() {
        super(new AbstractScoutWizardPage[0]);
    }

    @Override
    public IOperation addAdditionalPerformFinishOperation(IOperation op, double orderNr) {
        return this.m_performFinishOperations.put(new CompositeObject(new Object[]{orderNr, op}), op);
    }

    @Override
    public IOperation removeAdditionalPerformFinishOperation(IOperation op) {
        CompositeObject key = null;
        for (Map.Entry<CompositeObject, IOperation> e : this.m_performFinishOperations.entrySet()) {
            if (!CompareUtility.equals((Object)e.getValue(), (Object)op)) continue;
            key = e.getKey();
            break;
        }
        if (key != null) {
            return this.m_performFinishOperations.remove(key);
        }
        return null;
    }

    @Override
    public void addPage(IWizardPage page) {
        if (!(page instanceof AbstractWorkspaceWizardPage)) {
            throw new IllegalArgumentException("Expecting an instance of '" + AbstractWorkspaceWizardPage.class.getName() + "'.");
        }
        super.addPage(page);
    }

    @Override
    public final boolean performFinish() {
        block3: {
            try {
                if (this.beforeFinish()) break block3;
                ScoutSdkUi.logInfo("Wizard '" + this.getWindowTitle() + "' before finish canceled.");
                return false;
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("Wizard finished abnormally", e);
                return false;
            }
        }
        P_PerformFinishOperation performFinishOperation = new P_PerformFinishOperation(this.getShell().getDisplay());
        this.m_performFinishOperations.put(new CompositeObject(new Object[]{0.0, performFinishOperation}), performFinishOperation);
        OperationJob job = new OperationJob(this.m_performFinishOperations.values());
        job.schedule();
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            boolean validPage = false;
            AbstractWorkspaceWizardPage bcPage = (AbstractWorkspaceWizardPage)page;
            try {
                validPage = bcPage.performFinish(monitor, workingCopyManager);
            }
            catch (Exception e) {
                ScoutSdkUi.logError("exception during perfoming finish on wizard page '" + page.getClass().getName() + "'.", e);
                return false;
            }
            if (!validPage) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void postFinishDisplayThread() {
    }

    protected boolean beforeFinish() throws CoreException {
        return true;
    }

    private class P_PerformFinishOperation
    implements IOperation {
        private final Display m_display;

        private P_PerformFinishOperation(Display display) {
            this.m_display = display;
        }

        public String getOperationName() {
            return AbstractWorkspaceWizard.this.getWindowTitle();
        }

        public void validate() throws IllegalArgumentException {
        }

        public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
            block2: {
                try {
                    AbstractWorkspaceWizard.this.performFinish(monitor, workingCopyManager);
                    this.m_display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractWorkspaceWizard.this.postFinishDisplayThread();
                        }
                    });
                }
                catch (Exception e) {
                    ScoutSdkUi.logError("exception during perfoming finish on wizard page '" + AbstractWorkspaceWizard.this.getClass().getName() + "'.", e);
                    if (!(e instanceof CoreException)) break block2;
                    throw (CoreException)((Object)e);
                }
            }
        }
    }
}

