/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.code.type;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.codeid.CodeIdExtensionPoint;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.operation.CodeTypeNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureSubTypeProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.fields.code.CodeIdField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CodeTypeNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iCodeType = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType");
    private String m_nextCodeId;
    private String m_nextCodeIdSource;
    private INlsEntry m_nlsName;
    private String m_typeName;
    private String m_packageName;
    private IType m_superType;
    private IType m_defaultCodeType;
    private String m_genericSignature;
    private String m_genericCodeIdSignature;
    private ITypeParameter[] m_superTypeParameters;
    private CodeIdField m_nextCodeIdField;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private EntityTextField m_entityField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_genericTypeField;
    private ProposalTextField m_genericCodeIdField;
    private final IScoutBundle m_sharedBundle;

    public CodeTypeNewWizardPage(IScoutBundle sharedBundle) {
        super(CodeTypeNewWizardPage.class.getName());
        this.m_sharedBundle = sharedBundle;
        this.setTitle(Texts.get((String)"NewCodeType"));
        this.setDescription(Texts.get((String)"CreateANewCodeType"));
        if (this.m_sharedBundle != null) {
            this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)this.m_sharedBundle, (String)"shared.services.code"));
            this.m_defaultCodeType = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType", (IJavaProject)ScoutUtility.getJavaProject((IScoutBundle)this.m_sharedBundle));
        }
        this.m_superType = this.m_defaultCodeType;
        this.m_genericCodeIdSignature = this.m_genericSignature = SignatureCache.createTypeSignature((String)Long.class.getName());
    }

    @Override
    public void postActivate() {
        this.m_nlsNameField.setFocus();
    }

    @Override
    protected void createContent(Composite parent) {
        int labelColWidthPercent = 35;
        boolean isEnabled = this.getSharedBundle() != null;
        this.m_nextCodeIdField = new CodeIdField(parent, this.getSharedBundle(), labelColWidthPercent);
        this.m_nextCodeIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeTypeNewWizardPage.this.m_nextCodeId = CodeTypeNewWizardPage.this.m_nextCodeIdField.getValue();
                CodeTypeNewWizardPage.this.m_nextCodeIdSource = CodeTypeNewWizardPage.this.m_nextCodeIdField.getValueSource();
                CodeTypeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_nextCodeIdField.setEnabled(isEnabled);
        INlsProject nls = null;
        if (this.getSharedBundle() != null) {
            nls = this.getSharedBundle().getNlsProject();
        }
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, nls, Texts.get((String)"PropText"), labelColWidthPercent);
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeTypeNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = CodeTypeNewWizardPage.this.getNlsName();
                    CodeTypeNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (CodeTypeNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(CodeTypeNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)CodeTypeNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        CodeTypeNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)CodeTypeNewWizardPage.this.m_nlsName.getKey(), (boolean)false));
                    }
                }
                finally {
                    CodeTypeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_nlsNameField.setEnabled(isEnabled);
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"), labelColWidthPercent);
        this.m_typeNameField.setReadOnlySuffix("CodeType");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeTypeNewWizardPage.this.m_typeName = CodeTypeNewWizardPage.this.m_typeNameField.getText();
                CodeTypeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_typeNameField.setEnabled(isEnabled);
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField(parent, Texts.get((String)"EntityTextField"), this.getSharedBundle(), labelColWidthPercent);
            this.m_entityField.setText(this.getTargetPackage());
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CodeTypeNewWizardPage.this.setTargetPackageInternal(CodeTypeNewWizardPage.this.m_entityField.getText());
                    CodeTypeNewWizardPage.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
            this.m_entityField.setEnabled(isEnabled);
        }
        JavaElementAbstractTypeContentProvider contentProvider = new JavaElementAbstractTypeContentProvider(this.iCodeType, ScoutUtility.getJavaProject((IScoutBundle)this.getSharedBundle()), null, new IType[]{this.m_defaultCodeType});
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), contentProvider, labelColWidthPercent);
        final SignatureSubTypeProposalProvider genericProposalProvider = new SignatureSubTypeProposalProvider(this.getGenericTypeOfSuperClass("CODE_TYPE_ID"), this.getSharedBundle().getJavaProject());
        this.m_genericTypeField = this.getFieldToolkit().createProposalField(parent, Texts.get((String)"CodeTypeIdDatatype"), 1, labelColWidthPercent);
        this.m_genericTypeField.setContentProvider(genericProposalProvider);
        this.m_genericTypeField.setLabelProvider((IBaseLabelProvider)genericProposalProvider.getLabelProvider());
        final SignatureSubTypeProposalProvider genericCodeIdProposalProvider = new SignatureSubTypeProposalProvider(this.getGenericTypeOfSuperClass("CODE_ID"), this.getSharedBundle().getJavaProject());
        this.m_genericCodeIdField = this.getFieldToolkit().createProposalField(parent, Texts.get((String)"DatatypeOfNestedCodeIds"), 1, labelColWidthPercent);
        this.m_genericCodeIdField.setContentProvider(genericCodeIdProposalProvider);
        this.m_genericCodeIdField.setLabelProvider((IBaseLabelProvider)genericCodeIdProposalProvider.getLabelProvider());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeTypeNewWizardPage.this.setStateChanging(true);
                    CodeTypeNewWizardPage.this.m_superType = (IType)event.proposal;
                    CodeTypeNewWizardPage.this.m_superTypeParameters = TypeUtility.getTypeParameters((IType)CodeTypeNewWizardPage.this.getSuperType());
                    CodeTypeNewWizardPage.this.handleGenericFieldEnableState();
                    genericProposalProvider.setBaseType(CodeTypeNewWizardPage.this.getGenericTypeOfSuperClass("CODE_TYPE_ID"));
                    genericCodeIdProposalProvider.setBaseType(CodeTypeNewWizardPage.this.getGenericTypeOfSuperClass("CODE_ID"));
                }
                finally {
                    CodeTypeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.setEnabled(isEnabled);
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeTypeNewWizardPage.this.setStateChanging(true);
                    CodeTypeNewWizardPage.this.m_genericSignature = (String)event.proposal;
                    if (CodeTypeNewWizardPage.this.m_genericSignature != null) {
                        if (CodeTypeNewWizardPage.this.m_nextCodeId == null) {
                            CodeTypeNewWizardPage.this.setNextCodeId(CodeIdExtensionPoint.getNextCodeId((IScoutBundle)CodeTypeNewWizardPage.this.getSharedBundle(), (String)CodeTypeNewWizardPage.this.getGenericSignature()));
                        } else {
                            CodeTypeNewWizardPage.this.m_nextCodeIdSource = CodeTypeNewWizardPage.this.m_nextCodeIdField.getValueSource();
                        }
                    }
                }
                finally {
                    CodeTypeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_nextCodeIdField.setGenericTypeField(this.m_genericTypeField);
        this.m_genericCodeIdField.acceptProposal(this.getGenericCodeIdSignature());
        this.m_genericCodeIdField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeTypeNewWizardPage.this.setStateChanging(true);
                    CodeTypeNewWizardPage.this.m_genericCodeIdSignature = (String)event.proposal;
                }
                finally {
                    CodeTypeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nextCodeIdField.setLayoutData(new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_genericCodeIdField.setLayoutData(new GridData(768));
    }

    protected void handleGenericFieldEnableState() {
        this.m_genericTypeField.setEnabled(this.m_superTypeParameters.length > 0 && this.getSharedBundle() != null);
        this.m_genericCodeIdField.setEnabled(this.m_superTypeParameters.length > 1 && this.getSharedBundle() != null);
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        CodeTypeNewOperation op = new CodeTypeNewOperation(this.getTypeName(), this.getSharedBundle().getPackageName(this.getTargetPackage()), ScoutUtility.getJavaProject((IScoutBundle)this.getSharedBundle()));
        op.setNlsEntry(this.getNlsName());
        String sig = null;
        if (this.getGenericSignature() != null) {
            StringBuilder fqn = new StringBuilder(this.getSuperType().getFullyQualifiedName());
            if (this.m_superTypeParameters.length > 0) {
                fqn.append('<');
                fqn.append(Signature.toString((String)this.getGenericSignature()));
                if (this.m_superTypeParameters.length > 1) {
                    fqn.append(", ");
                    fqn.append(Signature.toString((String)this.getGenericCodeIdSignature()));
                    if (this.m_superTypeParameters.length > 2) {
                        fqn.append(", ");
                        fqn.append("org.eclipse.scout.rt.shared.services.common.code.ICode");
                        fqn.append('<');
                        fqn.append(Signature.toString((String)this.getGenericCodeIdSignature()));
                        fqn.append('>');
                    }
                }
                fqn.append('>');
                sig = SignatureCache.createTypeSignature((String)fqn.toString());
            } else {
                sig = SignatureCache.createTypeSignature((String)this.getSuperType().getFullyQualifiedName());
            }
        } else {
            sig = SignatureCache.createTypeSignature((String)this.getSuperType().getFullyQualifiedName());
        }
        op.setSuperTypeSignature(sig);
        op.setNextCodeId(this.getNextCodeIdSource());
        op.validate();
        op.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusWorkspace());
        multiStatus.add(this.getStatusNextCodeIdField());
        multiStatus.add(this.getStatusNameField());
        multiStatus.add(this.getStatusSuperType());
        multiStatus.add(this.getStatusGenericType());
        multiStatus.add(this.getStatusGenericCodeIdType());
        multiStatus.add(this.getStatusTargetPackge());
        multiStatus.add(this.getStatusGenericTypeToSuperClass(this.getGenericCodeIdSignature(), "CODE_ID"));
        multiStatus.add(this.getStatusGenericTypeToSuperClass(this.getGenericSignature(), "CODE_TYPE_ID"));
    }

    protected IStatus getStatusWorkspace() {
        if (this.getSharedBundle() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoNewXWithoutScoutBundle", (String[])new String[]{Texts.get((String)"CodeType")}));
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getSharedBundle() {
        return this.m_sharedBundle;
    }

    protected IStatus getStatusTargetPackge() {
        return ScoutUtility.validatePackageName((String)this.getTargetPackage());
    }

    protected IStatus getStatusNextCodeIdField() {
        if (this.isControlCreated() && this.m_nextCodeIdField.getEnabled()) {
            return this.m_nextCodeIdField.getStatus();
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"CodeType");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        IStatus existingStatus = ScoutUtility.validateTypeNotExisting((IScoutBundle)this.getSharedBundle(), (String)this.getTargetPackage(), (String)this.getTypeName());
        if (!existingStatus.isOK()) {
            return existingStatus;
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericType() {
        if (TypeUtility.isGenericType((IType)this.getSuperType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IType getGenericTypeOfSuperClass(String typeArgName) {
        try {
            String typeParamSig = SignatureUtility.resolveGenericParameterInSuperHierarchy((IType)this.getSuperType(), (ITypeHierarchy)this.getSuperType().newSupertypeHierarchy(null), (String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType", (String)typeArgName);
            if (typeParamSig != null) {
                return TypeUtility.getTypeBySignature((String)typeParamSig);
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError(e);
        }
        return null;
    }

    protected IStatus getStatusGenericTypeToSuperClass(String genericSignature, String superClassTypeArgName) {
        IType generic;
        IType superType;
        if (genericSignature != null && TypeUtility.exists((IJavaElement)(superType = this.getGenericTypeOfSuperClass(superClassTypeArgName))) && TypeUtility.exists((IJavaElement)(generic = TypeUtility.getTypeBySignature((String)genericSignature))) && !TypeUtility.getSuperTypeHierarchy((IType)generic).contains(superType)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeDoesNotMatchSuperClass"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericCodeIdType() {
        if (TypeUtility.isGenericType((IType)this.getSuperType()) && this.getGenericCodeIdSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public void setNextCodeId(String nextCodeId) {
        try {
            this.setStateChanging(true);
            this.m_nextCodeId = nextCodeId;
            if (this.isControlCreated()) {
                this.m_nextCodeIdField.setValue(nextCodeId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getNextCodeId() {
        return this.m_nextCodeId;
    }

    public String getNextCodeIdSource() {
        return this.m_nextCodeIdSource;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setGenericSignature(String genericSignature) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericSignature;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getGenericSignature() {
        return this.m_genericSignature;
    }

    public void setGenericCodeIdSignature(String genericCodeIdSignature) {
        try {
            this.setStateChanging(true);
            this.m_genericCodeIdSignature = genericCodeIdSignature;
            if (this.isControlCreated()) {
                this.m_genericCodeIdField.acceptProposal(genericCodeIdSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getGenericCodeIdSignature() {
        return this.m_genericCodeIdSignature;
    }

    public String getTargetPackage() {
        return this.m_packageName;
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.m_packageName = targetPackage;
    }
}

