/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.service.ProcessServiceNewOperation;
import org.eclipse.scout.sdk.operation.service.ServiceRegistrationDescription;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractServiceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.services.ProcessServiceNewWizardPage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ProcessServiceNewWizard
extends AbstractServiceWizard
implements INewWizard {
    private static final String TYPE_PERMISSION_CREATE = "permCreate";
    private static final String TYPE_PERMISSION_READ = "permRead";
    private static final String TYPE_PERMISSION_UPDATE = "permUpdate";
    private static final String TYPE_SERVICE_INTERFACE = "svcIfc";
    private static final String TYPE_SERVICE_IMPLEMENTATION = "svcImpl";
    private static final String TYPE_SERVICE_REG_CLIENT = "svcClientReg";
    private static final String TYPE_SERVICE_REG_SERVER = "svcServerReg";
    private BundleTreeWizardPage m_locationWizardPage;
    private ProcessServiceNewWizardPage m_serviceNewWizardPage;
    private ProcessServiceNewOperation m_operation;
    private ITreeNode m_locationWizardPageRoot;
    private IScoutBundle m_serverBundle;

    public ProcessServiceNewWizard() {
        this((IScoutBundle)null);
    }

    public ProcessServiceNewWizard(IScoutBundle serverBundle) {
        this.setWindowTitle(Texts.get((String)"NewProcessService"));
        this.m_serverBundle = serverBundle;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.m_serverBundle = UiUtility.getScoutBundleFromSelection(selection, this.m_serverBundle, ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SERVER"}));
        String pck = UiUtility.getPackageSuffix(selection);
        this.m_serviceNewWizardPage = new ProcessServiceNewWizardPage(this.m_serverBundle);
        this.m_serviceNewWizardPage.addPropertyChangeListener(new P_LocationPropertyListener());
        this.m_serviceNewWizardPage.setTargetPackage(pck);
        this.addPage((IWizardPage)this.m_serviceNewWizardPage);
        if (this.m_serverBundle != null) {
            P_StatusRevalidator statusProvider = new P_StatusRevalidator();
            this.m_locationWizardPageRoot = this.createTree(this.m_serverBundle);
            this.m_locationWizardPage = new BundleTreeWizardPage(Texts.get((String)"ProcessServiceLocation"), Texts.get((String)"OrganiseLocations"), this.m_locationWizardPageRoot, new AbstractServiceWizard.P_InitialCheckedFilter(this));
            this.m_locationWizardPage.addStatusProvider(statusProvider);
            this.m_locationWizardPage.addDndListener(new P_TreeDndListener());
            this.m_locationWizardPage.addCheckSelectionListener(new AbstractServiceWizard.P_SessionCheckListener(this));
            this.addPage((IWizardPage)this.m_locationWizardPage);
            this.m_serviceNewWizardPage.setSuperType(RuntimeClasses.getSuperType((String)"org.eclipse.scout.service.IService", (IJavaProject)this.m_serverBundle.getJavaProject()));
        }
    }

    private ITreeNode createTree(IScoutBundle serverBundle) {
        IScoutBundle sharedBundle = null;
        IScoutBundle clientBundle = null;
        sharedBundle = serverBundle.getParentBundle(ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getWorkspaceBundlesFilter(), ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"})}), false);
        if (sharedBundle != null) {
            clientBundle = sharedBundle.getChildBundle(ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getWorkspaceBundlesFilter(), ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"})}), serverBundle, false);
        }
        ITreeNode rootNode = TreeUtility.createBundleTree(serverBundle, NodeFilters.getByType("CLIENT", "SERVER", "SHARED"), ScoutBundleFilters.getWorkspaceBundlesFilter());
        if (clientBundle != null) {
            ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
            TreeUtility.createNode(clientNode, TYPE_SERVICE_REG_CLIENT, Texts.get((String)"ServiceProxyRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"));
        }
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, TYPE_PERMISSION_CREATE, Texts.get((String)"CreatePermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1);
            TreeUtility.createNode(sharedNode, TYPE_PERMISSION_READ, Texts.get((String)"ReadPermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 2);
            TreeUtility.createNode(sharedNode, TYPE_PERMISSION_UPDATE, Texts.get((String)"UpdatePermission"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 3);
            TreeUtility.createNode(sharedNode, TYPE_SERVICE_INTERFACE, Texts.get((String)"IService"), ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"), 4);
        }
        ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
        TreeUtility.createNode(serverNode, TYPE_SERVICE_IMPLEMENTATION, Texts.get((String)"Service"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1);
        ITreeNode svcRegNode = TreeUtility.createNode(serverNode, TYPE_SERVICE_REG_SERVER, Texts.get((String)"ServiceRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 2);
        this.refreshAvailableSessions(svcRegNode, svcRegNode);
        return rootNode;
    }

    @Override
    public BundleTreeWizardPage getLocationsPage() {
        return this.m_locationWizardPage;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle serviceInterfaceBundle;
        IScoutBundle[] proxyRegBundles;
        this.m_operation = new ProcessServiceNewOperation(this.m_locationWizardPage.getTextOfNode(TYPE_SERVICE_INTERFACE, true, true), this.m_locationWizardPage.getTextOfNode(TYPE_SERVICE_IMPLEMENTATION, true, true));
        this.m_serviceNewWizardPage.fillProcessServiceNewOperation(this.m_operation);
        IScoutBundle[] iScoutBundleArray = proxyRegBundles = this.m_locationWizardPage.getLocationBundles(TYPE_SERVICE_REG_CLIENT, true, true);
        int n = proxyRegBundles.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle b = iScoutBundleArray[n2];
            this.m_operation.addProxyRegistrationProject(b.getJavaProject());
            ++n2;
        }
        IScoutBundle permissionBundle = this.m_locationWizardPage.getLocationBundle(TYPE_PERMISSION_CREATE, true, true);
        if (permissionBundle != null) {
            this.m_operation.setPermissionsPackageName(permissionBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage("shared.security")));
            this.m_operation.setPermissionCreateProject(permissionBundle.getJavaProject());
            this.m_operation.setPermissionCreateName(this.m_locationWizardPage.getTextOfNode(TYPE_PERMISSION_CREATE, true, true));
            this.m_operation.setPermissionReadProject(this.m_locationWizardPage.getLocationBundle(TYPE_PERMISSION_READ, true, true).getJavaProject());
            this.m_operation.setPermissionReadName(this.m_locationWizardPage.getTextOfNode(TYPE_PERMISSION_READ, true, true));
            this.m_operation.setPermissionUpdateProject(this.m_locationWizardPage.getLocationBundle(TYPE_PERMISSION_UPDATE, true, true).getJavaProject());
            this.m_operation.setPermissionUpdateName(this.m_locationWizardPage.getTextOfNode(TYPE_PERMISSION_UPDATE, true, true));
        }
        for (ServiceRegistrationDescription desc : this.getCheckedServiceRegistrations(this.m_locationWizardPage.getTreeNodes(TYPE_SERVICE_REG_SERVER, true, true))) {
            this.m_operation.addServiceRegistration(desc);
            this.storeUsedSession(desc);
        }
        IScoutBundle serviceImplBundle = this.m_locationWizardPage.getLocationBundle(TYPE_SERVICE_IMPLEMENTATION, true, true);
        if (serviceImplBundle != null) {
            this.m_operation.setImplementationProject(serviceImplBundle.getJavaProject());
            this.m_operation.setImplementationPackageName(serviceImplBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage("server.services")));
        }
        if ((serviceInterfaceBundle = this.m_locationWizardPage.getLocationBundle(TYPE_SERVICE_INTERFACE, true, true)) != null) {
            this.m_operation.setInterfaceProject(serviceInterfaceBundle.getJavaProject());
            this.m_operation.setInterfacePackageName(serviceInterfaceBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage("shared.services")));
        }
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.validate();
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (IllegalArgumentException e) {
            ScoutSdkUi.logWarning("validation error of operation '" + this.m_operation.getOperationName() + "'. " + e.getMessage());
            return false;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during executing operation '" + this.m_operation.getOperationName() + "'.", e);
            return false;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = ProcessServiceNewWizard.this.m_serviceNewWizardPage.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    String prefix = typeName.replaceAll("Service$", "");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(ProcessServiceNewWizard.TYPE_PERMISSION_CREATE)).setText("Create" + prefix + "Permission");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(ProcessServiceNewWizard.TYPE_PERMISSION_READ)).setText("Read" + prefix + "Permission");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE)).setText("Update" + prefix + "Permission");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)).setText(String.valueOf(prefix) + "Service");
                    TreeUtility.findNode(ProcessServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE)).setText("I" + prefix + "Service");
                    ProcessServiceNewWizard.this.m_locationWizardPage.refreshTree();
                }
                ProcessServiceNewWizard.this.m_locationWizardPage.pingStateChanging();
            }
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusTypeNames());
            multiStatus.add(this.getStatusService());
            multiStatus.add(this.getStatusServiceRegistrationClient());
            multiStatus.add(this.getStatusServiceRegistrationServer());
        }

        protected IStatus getStatusTypeNames() {
            IStatus createStatus;
            ITreeNode serviceInterfaceNode;
            IScoutBundle serviceInterfaceBundle;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceImplementationBundle.getPackageName(ProcessServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage("server.services"))) + "." + serviceImplNode.getText();
                    if (serviceImplementationBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            if ((serviceInterfaceBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && (serviceInterfaceNode = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNode(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceInterfaceBundle.getPackageName(ProcessServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage("shared.services"))) + "." + serviceInterfaceNode.getText();
                    if (serviceInterfaceBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            if ((createStatus = this.getStatusPermission(ProcessServiceNewWizard.TYPE_PERMISSION_CREATE)) != Status.OK_STATUS) {
                return createStatus;
            }
            IStatus readStatus = this.getStatusPermission(ProcessServiceNewWizard.TYPE_PERMISSION_READ);
            if (readStatus != Status.OK_STATUS) {
                return readStatus;
            }
            IStatus updateStatus = this.getStatusPermission(ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE);
            if (updateStatus != Status.OK_STATUS) {
                return updateStatus;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusPermission(String permissionType) {
            ITreeNode permissionNode;
            IScoutBundle permissionBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(permissionType, true, true);
            if (permissionBundle != null && (permissionNode = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNode(permissionType, true, true)) != null) {
                try {
                    String fqn = String.valueOf(permissionBundle.getPackageName(ProcessServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage("shared.security"))) + "." + permissionNode.getText();
                    if (permissionBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + permissionNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceImplementationBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null) {
                IScoutBundle serviceInterfaceBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true);
                if (serviceInterfaceBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
                IScoutBundle permissionCreateBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_PERMISSION_CREATE, true, true);
                if (permissionCreateBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionCreateBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_PERMISSION_CREATE), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
                IScoutBundle permissionReadBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_PERMISSION_READ, true, true);
                if (permissionReadBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionReadBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_PERMISSION_READ), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
                IScoutBundle permissionUpdateBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE, true, true);
                if (permissionUpdateBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)permissionUpdateBundle, (IScoutBundle)serviceImplementationBundle)) {
                    return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE), ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationClient() {
            ITreeNode[] serviceRegistrationClientNodes;
            IScoutBundle serviceInterfaceBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationClientNodes = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNodes(ProcessServiceNewWizard.TYPE_SERVICE_REG_CLIENT, true, true);
            int n = serviceRegistrationClientNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = ProcessServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = ProcessServiceNewWizard.this.m_locationWizardPage.getTreeNodes(ProcessServiceNewWizard.TYPE_SERVICE_REG_SERVER, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceImplementationBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{ProcessServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            return TreeUtility.isOneOf(node.getType(), ProcessServiceNewWizard.TYPE_PERMISSION_CREATE, ProcessServiceNewWizard.TYPE_PERMISSION_READ, ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE, ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE, ProcessServiceNewWizard.TYPE_SERVICE_REG_CLIENT, ProcessServiceNewWizard.TYPE_SERVICE_REG_SERVER);
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.targetParent.getData() instanceof IScoutBundle && ((IScoutBundle)dndEvent.targetParent.getData()).isBinary()) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            if (dndEvent.node.getType() == ProcessServiceNewWizard.TYPE_SERVICE_REG_SERVER) {
                ProcessServiceNewWizard.this.refreshAvailableSessions(dndEvent.newNode, dndEvent.node);
            }
            ProcessServiceNewWizard.this.m_serviceNewWizardPage.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            String t = dndEvent.node.getType();
            dndEvent.doit = ProcessServiceNewWizard.TYPE_SERVICE_REG_CLIENT.equals(t) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (ProcessServiceNewWizard.TYPE_SERVICE_REG_SERVER.equals(t) ? "SERVER".equals(dndEvent.targetParent.getType()) : false);
        }

        private void validateDropMove(DndEvent dndEvent) {
            String t = dndEvent.node.getType();
            dndEvent.doit = ProcessServiceNewWizard.TYPE_SERVICE_REG_CLIENT.equals(t) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (TreeUtility.isOneOf(t, ProcessServiceNewWizard.TYPE_PERMISSION_CREATE, ProcessServiceNewWizard.TYPE_PERMISSION_READ, ProcessServiceNewWizard.TYPE_PERMISSION_UPDATE, ProcessServiceNewWizard.TYPE_SERVICE_INTERFACE) ? "SHARED".equals(dndEvent.targetParent.getType()) : (ProcessServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION.equals(t) || ProcessServiceNewWizard.TYPE_SERVICE_REG_SERVER.equals(t) ? "SERVER".equals(dndEvent.targetParent.getType()) : false));
        }
    }
}

