/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;

public class WorkingCopyManager
implements IWorkingCopyManager {
    private final Object LOCK = new Object();
    private List<ICompilationUnit> m_workingCopies = new ArrayList<ICompilationUnit>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(ICompilationUnit icu, IProgressMonitor monitor) throws JavaModelException {
        if (icu.isReadOnly()) {
            throw new IllegalArgumentException("try to get a working copy of the read only icu '" + icu.getElementName() + "'.");
        }
        Object object = this.LOCK;
        synchronized (object) {
            block5: {
                if (this.m_workingCopies.contains(icu)) break block5;
                icu.becomeWorkingCopy(monitor);
                this.m_workingCopies.add(icu);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAll(IProgressMonitor monitor) {
        Object object = this.LOCK;
        synchronized (object) {
            Iterator<ICompilationUnit> it = this.m_workingCopies.iterator();
            while (it.hasNext()) {
                this.releaseCompilationUnit(it.next(), monitor);
            }
            this.m_workingCopies.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ICompilationUnit icu, IProgressMonitor monitor) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.m_workingCopies.remove(icu)) {
                this.releaseCompilationUnit(icu, monitor);
            }
        }
    }

    public void discardAll(IProgressMonitor monitor) {
    }

    private void releaseCompilationUnit(ICompilationUnit icu, IProgressMonitor monitor) {
        try {
            try {
                if (!monitor.isCanceled()) {
                    icu.commitWorkingCopy(true, monitor);
                    this.indexCompilationUnitSync(icu);
                }
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logError("could not commit working copy '" + icu.getElementName() + "'", e);
                try {
                    icu.discardWorkingCopy();
                }
                catch (JavaModelException e2) {
                    SdkUtilActivator.logError("could not discard working copy '" + icu.getElementName() + "'", e2);
                }
            }
        }
        finally {
            try {
                icu.discardWorkingCopy();
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logError("could not discard working copy '" + icu.getElementName() + "'", e);
            }
        }
    }

    private void indexCompilationUnitSync(ICompilationUnit icu) {
        IJavaProject jp = icu.getJavaProject();
        IndexManager im = JavaModelManager.getIndexManager();
        IPath containerPath = jp.getProject().getFullPath();
        SourceElementParser parser = im.getSourceElementParser(jp, null);
        im.addSource((IFile)icu.getResource(), containerPath, parser);
        JdtUtility.waitForJobFamily(containerPath.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconcile(ICompilationUnit icu, IProgressMonitor monitor) throws CoreException {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.m_workingCopies.contains(icu)) {
                throw new CoreException((IStatus)new ScoutStatus("compilation unit " + icu.getElementName() + " has not been registered"));
            }
            icu.reconcile(0, true, icu.getOwner(), monitor);
        }
    }
}

