/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.operation.BindingFileCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.util.GlobalBindingRegistrationHelper;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;

public class CorruptBindingFileCommand
extends AbstractExecutableMarkerCommand {
    private IScoutBundle m_bundle;
    private IFile m_bindingFile;
    private WsdlResource m_wsdlResource;
    private GlobalBindingRegistrationHelper.SchemaCandidate m_schemaCandidate;

    public CorruptBindingFileCommand(IScoutBundle bundle, IFile bindingFile, WsdlResource wsdlResource) {
        super("Corrupt or missing binding file");
        this.m_bundle = bundle;
        this.m_bindingFile = bindingFile;
        this.m_wsdlResource = wsdlResource;
        this.setSolutionDescription("By using this task, a new binding file '" + this.m_bindingFile.getProjectRelativePath() + "' is created.");
    }

    @Override
    public boolean prepareForUi() throws CoreException {
        block2: {
            try {
                this.m_schemaCandidate = GlobalBindingRegistrationHelper.popupForSchema(this.m_wsdlResource.getFile());
            }
            catch (CoreException e) {
                if (e.getStatus() == null || e.getStatus().getCode() != Status.CANCEL_STATUS.getCode()) break block2;
                return false;
            }
        }
        return true;
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IPath bindingFilePath = this.m_bindingFile.getProjectRelativePath();
        IFolder wsdlFolder = JaxWsSdkUtility.getParentFolder(this.m_bundle, this.m_wsdlResource.getFile());
        BindingFileCreateOperation op = new BindingFileCreateOperation();
        op.setBundle(this.m_bundle);
        op.setProjectRelativePath(bindingFilePath);
        op.setWsdlDestinationFolder(wsdlFolder);
        if (this.m_schemaCandidate != null) {
            SchemaUtility.WsdlArtifact<IFile> wsdlArtifact = this.m_schemaCandidate.getWsdlArtifact();
            if (wsdlArtifact.getInlineSchemas().length > 1) {
                op.setSchemaTargetNamespace(SchemaUtility.getSchemaTargetNamespace(this.m_schemaCandidate.getSchema()));
            }
            if (wsdlArtifact.getTypeEnum() == SchemaUtility.WsdlArtifact.TypeEnum.ReferencedWsdl) {
                op.setWsdlLocation((IFile)wsdlArtifact.getFileHandle().getFile());
            }
        }
        op.run(monitor, workingCopyManager);
    }
}

