/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPresenterValueChangedListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class AbstractPropertyPresenter<T>
extends AbstractPresenter {
    public static final int DEFAULT_LABEL_WIDTH = 120;
    private T m_value;
    protected int m_presenterId;
    private Composite m_container;
    private String m_labelText;
    private ImageDescriptor m_iconImageDescriptor;
    private String m_iconTooltip;
    private String m_tooltip;
    private String m_resetTooltip;
    private List<IPresenterValueChangedListener> m_valueChangedListeners;
    private boolean m_acceptNullValue;
    private boolean m_boldLabelText;
    private boolean m_useLinkAsLabel;
    private boolean m_resetLinkVisible;
    private boolean m_linkAlwaysEnabled;
    private int m_labelWidth;
    private Label m_label;
    private Hyperlink m_link;
    protected Control m_content;
    private Label m_statusIcon;
    private Label m_icon;
    protected ImageHyperlink m_resetLink;
    private JaxWsConstants.MarkerType m_markerType;
    protected IScoutBundle m_bundle;
    private String m_markerGroupUUID;
    private String m_customInfo;
    private int m_customSeverity;
    private int m_stateChanging;

    public AbstractPropertyPresenter(Composite parent, PropertyViewFormToolkit toolkit) {
        this(parent, toolkit, 120, true);
    }

    public AbstractPropertyPresenter(Composite parent, PropertyViewFormToolkit toolkit, boolean initialize) {
        this(parent, toolkit, 120, initialize);
    }

    public AbstractPropertyPresenter(Composite parent, PropertyViewFormToolkit toolkit, int labelWidth, boolean initialize) {
        super(toolkit, parent);
        this.m_labelWidth = labelWidth;
        this.m_valueChangedListeners = new LinkedList<IPresenterValueChangedListener>();
        this.m_resetTooltip = Texts.get("Remove");
        if (initialize) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        this.createPresenter();
    }

    private Control createPresenter() {
        this.m_container = this.getContainer();
        this.m_label = new Label(this.m_container, 0);
        this.m_label.setText(StringUtility.join((String)"", (Object[])new Object[]{this.m_labelText, ":"}));
        this.m_label.setToolTipText(this.m_tooltip);
        this.m_link = this.getToolkit().createHyperlink(this.m_container, StringUtility.join((String)"", (Object[])new Object[]{this.m_labelText, ":"}), 0);
        this.m_link.setToolTipText(this.m_tooltip);
        this.m_link.setUnderlined(true);
        this.m_link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                try {
                    AbstractPropertyPresenter.this.execLinkAction();
                }
                catch (CoreException e) {
                    JaxWsSdk.logError(e);
                }
            }
        });
        this.m_icon = new Label(this.m_container, 0);
        if (this.getIconImageDescriptor() != null) {
            this.m_icon.setImage(this.getIconImageDescriptor().createImage());
        }
        this.m_icon.setToolTipText(StringUtility.nvl((Object)this.getIconTooltip(), (String)""));
        this.m_content = this.createContent(this.m_container);
        this.m_statusIcon = new Label(this.m_container, 0);
        this.m_statusIcon.setImage(ScoutSdkUi.getImage((String)"error.gif"));
        this.m_resetLink = this.getToolkit().createImageHyperlink(this.m_container, 0);
        this.m_resetLink.setToolTipText(StringUtility.nvl((Object)this.m_resetTooltip, (String)""));
        this.m_resetLink.setImage(ScoutSdkUi.getImage((String)"remove.png"));
        this.m_resetLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                try {
                    AbstractPropertyPresenter.this.execResetAction();
                }
                catch (CoreException e) {
                    JaxWsSdk.logError(e);
                }
            }
        });
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.numColumns = 5;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 2;
        layout.makeColumnsEqualWidth = false;
        this.m_container.setLayout((Layout)layout);
        boolean labelVisible = !this.m_useLinkAsLabel;
        GridData gd = new GridData();
        gd.widthHint = this.m_labelWidth;
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = false;
        gd.exclude = !labelVisible;
        gd.horizontalIndent = 1;
        this.m_label.setLayoutData((Object)gd);
        this.m_label.setVisible(labelVisible);
        boolean linkVisible = this.m_useLinkAsLabel;
        gd = new GridData();
        gd.widthHint = this.m_labelWidth;
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = false;
        gd.exclude = !linkVisible;
        this.m_link.setLayoutData((Object)gd);
        this.m_link.setVisible(linkVisible);
        gd = new GridData();
        gd.widthHint = 16;
        gd.horizontalAlignment = 131072;
        this.m_icon.setLayoutData((Object)gd);
        this.m_icon.setVisible(this.getIconImageDescriptor() != null);
        gd = new GridData(768);
        gd.horizontalIndent = 5;
        gd.grabExcessHorizontalSpace = true;
        this.m_content.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        this.m_statusIcon.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.exclude = !this.m_resetLinkVisible;
        gd.horizontalIndent = 5;
        this.m_resetLink.setLayoutData((Object)gd);
        this.m_resetLink.setVisible(this.m_resetLinkVisible);
        this.setUseLinkAsLabel(this.m_useLinkAsLabel);
        this.setBoldLabelText(this.m_boldLabelText);
        return this.m_container;
    }

    public void setPresenterId(int presenterId) {
        this.m_presenterId = presenterId;
    }

    public void setLabel(String label) {
        this.m_labelText = label;
        if (this.isControlCreated()) {
            this.m_label.setText(StringUtility.nvl((Object)this.m_labelText, (String)""));
            this.m_link.setText(StringUtility.nvl((Object)this.m_labelText, (String)""));
        }
    }

    public String getLabel() {
        return this.m_labelText;
    }

    public ImageDescriptor getIconImageDescriptor() {
        return this.m_iconImageDescriptor;
    }

    public void setIconImageDescriptor(ImageDescriptor iconImageDescriptor) {
        this.m_iconImageDescriptor = iconImageDescriptor;
        if (this.isControlCreated()) {
            if (iconImageDescriptor != null) {
                this.m_icon.setImage(iconImageDescriptor.createImage());
            } else {
                this.m_icon.setImage(null);
            }
            this.m_icon.setToolTipText(StringUtility.nvl((Object)this.m_iconTooltip, (String)""));
            this.m_icon.setVisible(iconImageDescriptor != null);
            this.m_icon.getParent().layout(true);
        }
    }

    public String getIconTooltip() {
        return this.m_iconTooltip;
    }

    public void setIconTooltip(String iconTooltip) {
        this.m_iconTooltip = iconTooltip;
        if (this.isControlCreated()) {
            this.m_icon.setToolTipText(StringUtility.nvl((Object)iconTooltip, (String)""));
        }
    }

    public void setTooltip(String tooltip) {
        this.m_tooltip = tooltip;
        if (this.isControlCreated()) {
            this.m_label.setToolTipText(StringUtility.nvl((Object)tooltip, (String)""));
            this.m_link.setToolTipText(StringUtility.nvl((Object)tooltip, (String)""));
        }
    }

    public void setResetTooltip(String resetTooltip) {
        this.m_resetTooltip = resetTooltip;
        if (this.isControlCreated()) {
            this.m_resetLink.setToolTipText(StringUtility.nvl((Object)resetTooltip, (String)""));
        }
    }

    public boolean isUseLinkAsLabel() {
        return this.m_useLinkAsLabel;
    }

    public void setUseLinkAsLabel(boolean useLinkAsLabel) {
        if (this.m_useLinkAsLabel == useLinkAsLabel) {
            return;
        }
        this.m_useLinkAsLabel = useLinkAsLabel;
        if (this.isControlCreated()) {
            ((GridData)this.m_label.getLayoutData()).exclude = this.m_useLinkAsLabel;
            this.m_label.setVisible(!this.m_useLinkAsLabel);
            ((GridData)this.m_link.getLayoutData()).exclude = !this.m_useLinkAsLabel;
            this.m_link.setVisible(this.m_useLinkAsLabel);
            this.m_container.layout();
        }
    }

    public boolean isLinkAlwaysEnabled() {
        return this.m_linkAlwaysEnabled;
    }

    public void setLinkAlwaysEnabled(boolean linkAlwaysEnabled) {
        this.m_linkAlwaysEnabled = linkAlwaysEnabled;
        if (linkAlwaysEnabled && this.isControlCreated()) {
            this.m_link.setEnabled(true);
        }
    }

    public void setEnabled(boolean enabled) {
        if (!this.isLinkAlwaysEnabled()) {
            super.setEnabled(enabled);
        } else {
            this.m_content.setEnabled(enabled);
            this.m_label.setEnabled(enabled);
            this.m_icon.setEnabled(enabled);
            this.m_statusIcon.setEnabled(enabled);
        }
    }

    public boolean isResetLinkVisible() {
        return this.m_resetLinkVisible;
    }

    public void setResetLinkVisible(boolean resetLinkVisible) {
        if (this.m_resetLinkVisible == resetLinkVisible) {
            return;
        }
        this.m_resetLinkVisible = resetLinkVisible;
        if (this.isControlCreated()) {
            ((GridData)this.m_resetLink.getLayoutData()).exclude = !this.m_resetLinkVisible;
            this.m_resetLink.setVisible(this.m_resetLinkVisible);
            this.m_container.layout();
        }
    }

    public void setMarkerType(JaxWsConstants.MarkerType markerType) {
        this.m_markerType = markerType;
    }

    public JaxWsConstants.MarkerType getMarkerType() {
        return this.m_markerType;
    }

    public void setMarkerGroupUUID(String markerGroupUUID) {
        this.m_markerGroupUUID = markerGroupUUID;
    }

    public String getMarkerGroupUUID() {
        return this.m_markerGroupUUID;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public void addValueChangedListener(IPresenterValueChangedListener listener) {
        this.m_valueChangedListeners.add(listener);
    }

    public void removeValueChangedListener(IPresenterValueChangedListener listener) {
        this.m_valueChangedListeners.remove(listener);
    }

    public void setInput(T value) {
        if (this.m_container == null) {
            this.createPresenter();
        }
        if (this.m_container.isDisposed()) {
            return;
        }
        this.clearInfo();
        try {
            this.m_value = value;
            this.setInputInternal(value);
        }
        finally {
            this.updateInfo();
        }
    }

    public void setInfo(int severity, String info) {
        this.m_customSeverity = severity;
        this.m_customInfo = info;
        this.updateInfo();
    }

    public void clearInfo() {
        this.clearInfo(true);
    }

    public void clearInfo(boolean updateUi) {
        this.m_customInfo = null;
        this.m_customSeverity = 0;
        if (updateUi) {
            this.updateInfo();
        }
    }

    public void updateInfo() {
        Image image;
        if (this.isDisposed()) {
            return;
        }
        String info = null;
        int severity = 0;
        ArrayList<SeverityEntry> statusList = new ArrayList<SeverityEntry>();
        statusList.add(new SeverityEntry(NumberUtility.nvl((Integer)this.m_customSeverity, (Number)0), this.m_customInfo));
        if (this.m_markerType != null && this.m_bundle != null) {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = MarkerUtility.getMarkers(this.m_bundle, this.m_markerType, this.m_markerGroupUUID);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                statusList.add(new SeverityEntry(marker.getAttribute("severity", 0), marker.getAttribute("message", null)));
                ++n2;
            }
        }
        try {
            this.updateSeverity(statusList);
        }
        catch (CoreException e) {
            JaxWsSdk.logError(e);
        }
        for (SeverityEntry severityEntry : statusList) {
            severity = Math.max(severity, severityEntry.getSeverity());
            if (!StringUtility.hasText((String)severityEntry.getMessage())) continue;
            info = StringUtility.join((String)("\n" + info), (Object[])new Object[]{severityEntry.getMessage()});
        }
        switch (severity) {
            case 1: {
                image = ScoutSdkUi.getImage((String)"warning.gif");
                break;
            }
            case 2: {
                image = ScoutSdkUi.getImage((String)"error.gif");
                break;
            }
            default: {
                image = ScoutSdkUi.getImage((String)"info.gif");
            }
        }
        if (!StringUtility.hasText(info)) {
            info = null;
        }
        GridData gridDataIcon = (GridData)this.m_statusIcon.getLayoutData();
        if (severity == 0 && info == null) {
            if (!gridDataIcon.exclude) {
                gridDataIcon.exclude = true;
                this.m_statusIcon.setVisible(false);
                this.m_container.layout();
            }
        } else {
            this.m_statusIcon.setImage(image);
            this.m_statusIcon.setToolTipText(StringUtility.nvl(info, (String)""));
            if (gridDataIcon.exclude) {
                gridDataIcon.exclude = false;
                this.m_statusIcon.setVisible(true);
                this.m_container.layout();
            }
        }
    }

    public T getValue() {
        return this.m_value;
    }

    public boolean isAcceptNullValue() {
        return this.m_acceptNullValue;
    }

    public void setAcceptNullValue(boolean acceptNullValue) {
        this.m_acceptNullValue = acceptNullValue;
    }

    public boolean isBoldLabelText() {
        return this.m_boldLabelText;
    }

    public void setBoldLabelText(boolean boldLabelText) {
        if (this.m_boldLabelText == boldLabelText) {
            return;
        }
        this.m_boldLabelText = boldLabelText;
        if (this.isControlCreated()) {
            this.m_link.setFont(this.getFont("org.eclipse.jface.dialogfont", boldLabelText));
            this.m_label.setFont(this.getFont("org.eclipse.jface.dialogfont", boldLabelText));
        }
    }

    protected void setValueFromUI(T newValue) {
        this.setValueFromUI(newValue, false);
    }

    protected void setValueFromUI(T newValue, boolean force) {
        if (!(this.isStateChanging() || !force && CompareUtility.equals(this.getValue(), newValue) || newValue == null && !this.isAcceptNullValue())) {
            this.m_value = newValue;
            IPresenterValueChangedListener[] iPresenterValueChangedListenerArray = this.m_valueChangedListeners.toArray(new IPresenterValueChangedListener[this.m_valueChangedListeners.size()]);
            int n = iPresenterValueChangedListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPresenterValueChangedListener listener = iPresenterValueChangedListenerArray[n2];
                try {
                    listener.propertyChanged(this.m_presenterId, newValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        this.clearInfo();
    }

    protected abstract void setInputInternal(T var1);

    protected abstract Control createContent(Composite var1);

    protected boolean isControlCreated() {
        return this.m_container != null && !this.m_container.isDisposed();
    }

    protected boolean isStateChanging() {
        return this.m_stateChanging > 0;
    }

    public void setStateChanging(boolean b) {
        this.m_stateChanging = b ? ++this.m_stateChanging : --this.m_stateChanging;
    }

    protected void execLinkAction() throws CoreException {
    }

    protected void execResetAction() throws CoreException {
    }

    protected void updateSeverity(List<SeverityEntry> statusList) throws CoreException {
    }

    public static class SeverityEntry {
        private int m_severity;
        private String m_message;

        public SeverityEntry(int severity, String message) {
            this.m_severity = severity;
            this.m_message = message;
        }

        public int getSeverity() {
            return this.m_severity;
        }

        public void setSeverity(int severity) {
            this.m_severity = severity;
        }

        public String getMessage() {
            return this.m_message;
        }

        public void setMessage(String message) {
            this.m_message = message;
        }
    }
}

