/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewPackageWizardAction;
import org.eclipse.jdt.ui.wizards.NewPackageWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AbstractPropertyPresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PackagePresenter
extends AbstractPropertyPresenter<String> {
    private Text m_textField;
    private Button m_button;
    private ModifyListener m_modifyListener;
    private String m_sourceFolder;
    private boolean m_allowChangeOfSourceFolder;

    public PackagePresenter(Composite parent, PropertyViewFormToolkit toolkit) {
        super(parent, toolkit, false);
        this.setLabel(Texts.get("package"));
        this.setUseLinkAsLabel(true);
        this.m_modifyListener = new P_ModifyListener();
        this.callInitializer();
    }

    @Override
    protected Control createContent(Composite parent) {
        Composite composite = this.getToolkit().createComposite(parent, 0);
        this.m_textField = this.getToolkit().createText(composite, "", 2308);
        this.m_textField.setEditable(true);
        this.m_textField.addModifyListener(this.m_modifyListener);
        this.m_textField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String packageName = PackagePresenter.this.m_textField.getText();
                if (PackagePresenter.this.validate(packageName)) {
                    PackagePresenter.this.setValueFromUI(packageName);
                }
            }
        });
        this.m_button = new Button(composite, 0x800008);
        this.m_button.setText(String.valueOf(Texts.get("Browse")) + "...");
        this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String packageName = PackagePresenter.this.openPackageBrowserDialog();
                if (packageName == null) {
                    return;
                }
                if (PackagePresenter.this.validate(packageName)) {
                    PackagePresenter.this.setInputInternal(packageName);
                    PackagePresenter.this.setValueFromUI(packageName);
                }
            }
        });
        composite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.m_button, -3, 16384);
        formData.bottom = new FormAttachment(100, 0);
        this.m_textField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.m_button.setLayoutData((Object)formData);
        return composite;
    }

    @Override
    protected void execLinkAction() throws CoreException {
        IPackageFragment packageFragment = this.getPackageFragment(this.m_textField.getText());
        if (packageFragment != null) {
            try {
                JavaUI.openInEditor((IJavaElement)packageFragment);
            }
            catch (Exception e) {
                JaxWsSdk.logWarning(e);
            }
        } else {
            String packageName = this.openPackageNewDialog();
            if (packageName != null) {
                this.setInputInternal(packageName);
                this.setValueFromUI(packageName, true);
            }
        }
    }

    @Override
    protected void setInputInternal(String input) {
        this.m_textField.removeModifyListener(this.m_modifyListener);
        try {
            this.m_textField.setText(StringUtility.nvl((Object)input, (String)""));
        }
        finally {
            this.m_textField.addModifyListener(this.m_modifyListener);
        }
        this.validate(input);
    }

    private String openPackageNewDialog() throws JavaModelException {
        NewPackageWizardPage page = new NewPackageWizardPage();
        page.setDescription(Texts.get("CreateNewPackage"));
        page.setPackageText(this.m_textField.getText(), true);
        if (!this.isAllowChangeOfSourceFolder() && !JaxWsSdkUtility.isValidSourceFolder(this.m_bundle, this.m_sourceFolder)) {
            return null;
        }
        if (this.m_sourceFolder != null) {
            IPath sourceFolder = this.m_bundle.getProject().getFullPath().append(this.m_sourceFolder);
            IPackageFragmentRoot root = this.m_bundle.getJavaProject().findPackageFragmentRoot(sourceFolder);
            page.setPackageFragmentRoot(root, this.isAllowChangeOfSourceFolder());
        }
        OpenNewPackageWizardAction action = new OpenNewPackageWizardAction();
        action.setConfiguredWizardPage(page);
        action.run();
        IPackageFragment packageFragment = page.getNewPackageFragment();
        if (packageFragment != null && packageFragment.exists() && this.validate(packageFragment.getElementName())) {
            this.m_sourceFolder = page.getPackageFragmentRoot().getPath().lastSegment();
            return packageFragment.getElementName();
        }
        return null;
    }

    private String openPackageBrowserDialog() {
        IPackageFragment packageFragment;
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        SelectionDialog dialog = JavaUI.createPackageDialog((Shell)ScoutSdkUi.getShell(), (IRunnableContext)context, (IJavaSearchScope)this.createSearchScopeForSourceFolder(), (boolean)false, (boolean)true, null);
        dialog.setTitle(Texts.get("CreateNewPackage"));
        if (dialog.open() == 0 && dialog.getResult() != null && dialog.getResult().length > 0 && TypeUtility.exists((IJavaElement)(packageFragment = (IPackageFragment)dialog.getResult()[0]))) {
            this.m_sourceFolder = packageFragment.getParent().getPath().lastSegment();
            return packageFragment.getElementName();
        }
        return null;
    }

    private boolean validate(String packageName) {
        block7: {
            IPackageFragmentRoot root;
            block6: {
                this.setUseLinkAsLabel(false);
                if (!JaxWsSdkUtility.isValidSourceFolder(this.m_bundle, this.m_sourceFolder)) {
                    this.setInfo(2, "Source folder not set set or does not exist");
                    return false;
                }
                if (packageName == null) {
                    this.clearInfo();
                    return this.isAcceptNullValue();
                }
                try {
                    IPath sourceFolder = this.m_bundle.getProject().getFullPath().append(this.m_sourceFolder);
                    root = this.m_bundle.getJavaProject().findPackageFragmentRoot(sourceFolder);
                    if (TypeUtility.exists((IJavaElement)root)) break block6;
                    this.setInfo(2, "Source folder could not be found");
                    return false;
                }
                catch (JavaModelException e) {
                    JaxWsSdk.logError("failed to validate package name", e);
                    this.clearInfo();
                    return false;
                }
            }
            IPackageFragment packageFragment = root.getPackageFragment(packageName);
            if ((packageFragment == null || packageFragment.exists()) && (packageFragment != null || this.isAcceptNullValue())) break block7;
            this.setUseLinkAsLabel(true);
            this.setInfo(1, Texts.get("PackageDoesNotExistClickOnLinkToCreate"));
            return false;
        }
        this.clearInfo();
        return true;
    }

    private IPackageFragment getPackageFragment(String packageName) {
        if (this.validate(packageName)) {
            IPath sourceFolder = this.m_bundle.getProject().getFullPath().append(this.m_sourceFolder);
            try {
                IPackageFragmentRoot root = this.m_bundle.getJavaProject().findPackageFragmentRoot(sourceFolder);
                return root.getPackageFragment(packageName);
            }
            catch (JavaModelException e) {
                JaxWsSdk.logError("failed to get package fragment", e);
            }
        }
        return null;
    }

    public String getSourceFolder() {
        return this.m_sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.m_sourceFolder = sourceFolder;
        if (this.isControlCreated()) {
            this.validate(this.m_textField.getText());
        }
    }

    public boolean isAllowChangeOfSourceFolder() {
        return this.m_allowChangeOfSourceFolder;
    }

    public void setAllowChangeOfSourceFolder(boolean allowChangeOfSourceFolder) {
        this.m_allowChangeOfSourceFolder = allowChangeOfSourceFolder;
    }

    private IJavaSearchScope createSearchScopeForSourceFolder() {
        if (JaxWsSdkUtility.isValidSourceFolder(this.m_bundle, this.m_sourceFolder)) {
            try {
                IPath sourceFolder = this.m_bundle.getProject().getFullPath().append(this.m_sourceFolder);
                IPackageFragmentRoot root = this.m_bundle.getJavaProject().findPackageFragmentRoot(sourceFolder);
                return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root});
            }
            catch (JavaModelException e) {
                JaxWsSdk.logError("failed to create Java search scope for package elements", e);
            }
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]);
    }

    private class P_ModifyListener
    implements ModifyListener {
        private P_ModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (PackagePresenter.this.validate(PackagePresenter.this.m_textField.getText())) {
                PackagePresenter.this.setValueFromUI(PackagePresenter.this.m_textField.getText());
            }
        }
    }
}

