/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import org.openqa.selenium.Keys;

public class KeyboardModifiersState {
    private boolean shiftPressed = false;
    private boolean ctrlPressed = false;
    private boolean altPressed = false;

    public boolean isShiftPressed() {
        return this.shiftPressed;
    }

    public boolean isCtrlPressed() {
        return this.ctrlPressed;
    }

    public boolean isAltPressed() {
        return this.altPressed;
    }

    public void storeKeyDown(Keys key) {
        this.storeIfEqualsShift(key, true);
        this.storeIfEqualsCtrl(key, true);
        this.storeIfEqualsAlt(key, true);
    }

    public void storeKeyUp(Keys key) {
        this.storeIfEqualsShift(key, false);
        this.storeIfEqualsCtrl(key, false);
        this.storeIfEqualsAlt(key, false);
    }

    private void storeIfEqualsShift(Keys key, boolean keyState) {
        if (key.equals(Keys.SHIFT)) {
            this.shiftPressed = keyState;
        }
    }

    private void storeIfEqualsCtrl(Keys key, boolean keyState) {
        if (key.equals(Keys.CONTROL)) {
            this.ctrlPressed = keyState;
        }
    }

    private void storeIfEqualsAlt(Keys key, boolean keyState) {
        if (key.equals(Keys.ALT)) {
            this.altPressed = keyState;
        }
    }
}

