/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.html;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.html.IHtmlContent;
import org.eclipse.scout.commons.html.IHtmlDocument;
import org.eclipse.scout.commons.html.IHtmlElement;
import org.eclipse.scout.commons.html.IHtmlInput;
import org.eclipse.scout.commons.html.IHtmlListElement;
import org.eclipse.scout.commons.html.IHtmlTable;
import org.eclipse.scout.commons.html.IHtmlTableCell;
import org.eclipse.scout.commons.html.IHtmlTableRow;
import org.eclipse.scout.commons.html.internal.EmptyHtmlNodeBuilder;
import org.eclipse.scout.commons.html.internal.HtmlContentBuilder;
import org.eclipse.scout.commons.html.internal.HtmlDocumentBuilder;
import org.eclipse.scout.commons.html.internal.HtmlImageBuilder;
import org.eclipse.scout.commons.html.internal.HtmlInputBuilder;
import org.eclipse.scout.commons.html.internal.HtmlLinkBuilder;
import org.eclipse.scout.commons.html.internal.HtmlListElement;
import org.eclipse.scout.commons.html.internal.HtmlNodeBuilder;
import org.eclipse.scout.commons.html.internal.HtmlPlainBuilder;
import org.eclipse.scout.commons.html.internal.HtmlTableBuilder;
import org.eclipse.scout.commons.html.internal.HtmlTableDataBuilder;
import org.eclipse.scout.commons.html.internal.HtmlTableRowBuilder;
import org.eclipse.scout.commons.html.internal.StyleElementBuilder;

public final class HTML {
    private static final Pattern htmlMarkupAmp = Pattern.compile("[&]");
    private static final Pattern htmlMarkupLt = Pattern.compile("[<]");
    private static final Pattern htmlMarkupGt = Pattern.compile("[>]");
    private static final Pattern htmlMarkupQuot = Pattern.compile("[\"]");
    private static final Pattern htmlMarkupApo = Pattern.compile("[']");
    private static final Pattern htmlMarkupSlash = Pattern.compile("[/]");

    private HTML() {
    }

    public static IHtmlContent head(CharSequence ... elements) {
        return new HtmlNodeBuilder("head", elements);
    }

    public static IHtmlContent body(CharSequence ... elements) {
        return new HtmlNodeBuilder("body", elements);
    }

    public static IHtmlElement bold(CharSequence ... text) {
        return new HtmlNodeBuilder("b", text);
    }

    public static IHtmlElement italic(CharSequence ... text) {
        return new HtmlNodeBuilder("i", text);
    }

    public static IHtmlElement p(CharSequence ... text) {
        return new HtmlNodeBuilder("p", text);
    }

    public static IHtmlElement br() {
        return new EmptyHtmlNodeBuilder("br");
    }

    public static IHtmlElement h1(CharSequence ... text) {
        return new HtmlNodeBuilder("h1", text);
    }

    public static IHtmlElement h2(CharSequence ... text) {
        return new HtmlNodeBuilder("h2", text);
    }

    public static IHtmlElement h3(CharSequence ... text) {
        return new HtmlNodeBuilder("h3", text);
    }

    public static IHtmlElement h4(CharSequence ... text) {
        return new HtmlNodeBuilder("h4", text);
    }

    public static IHtmlElement h5(CharSequence ... text) {
        return new HtmlNodeBuilder("h5", text);
    }

    public static IHtmlElement h6(CharSequence ... text) {
        return new HtmlNodeBuilder("h6", text);
    }

    public static IHtmlElement div(CharSequence ... content) {
        return new HtmlNodeBuilder("div", Arrays.asList(content));
    }

    public static IHtmlElement div(List<CharSequence> contents) {
        return new HtmlNodeBuilder("div", contents);
    }

    public static IHtmlElement span(CharSequence ... text) {
        return new HtmlNodeBuilder("span", text);
    }

    public static IHtmlElement link(CharSequence url, CharSequence text) {
        return new HtmlLinkBuilder(url, text);
    }

    public static IHtmlElement img(CharSequence src) {
        return new HtmlImageBuilder(src);
    }

    public static IHtmlElement imgByBinaryResource(CharSequence binaryResource) {
        return new HtmlImageBuilder((CharSequence)("binaryResource:" + binaryResource));
    }

    public static IHtmlElement imgByIconId(CharSequence iconId) {
        return new HtmlImageBuilder((CharSequence)("iconId:" + iconId));
    }

    public static IHtmlListElement li(CharSequence text) {
        return new HtmlListElement(text);
    }

    public static IHtmlElement ul(IHtmlListElement ... li) {
        return HTML.ul(Arrays.asList(li));
    }

    public static IHtmlElement ul(List<IHtmlListElement> li) {
        return new HtmlNodeBuilder("ul", li);
    }

    public static IHtmlContent ol(IHtmlListElement ... li) {
        return new HtmlNodeBuilder("ol", (CharSequence[])li);
    }

    public static IHtmlTableCell cell(CharSequence ... text) {
        return new HtmlTableDataBuilder(Arrays.asList(text));
    }

    public static IHtmlTableRow row(IHtmlTableCell ... td) {
        return HTML.row(Arrays.asList(td));
    }

    public static IHtmlTableRow row(List<IHtmlTableCell> td) {
        return new HtmlTableRowBuilder((List<? extends IHtmlTableCell>)td);
    }

    public static IHtmlTable table(IHtmlTableRow ... rows) {
        return new HtmlTableBuilder(Arrays.asList(rows));
    }

    public static IHtmlTable table(List<IHtmlTableRow> rows) {
        return new HtmlTableBuilder(rows);
    }

    public static IHtmlElement appLink(CharSequence ref, CharSequence text) {
        return HTML.span(text).appLink(ref);
    }

    public static IHtmlContent fragment(CharSequence ... elements) {
        return new HtmlContentBuilder(elements);
    }

    public static IHtmlContent fragment(List<? extends CharSequence> elements) {
        return new HtmlContentBuilder(elements);
    }

    public static IHtmlElement cssStyle(CharSequence ... cssContent) {
        return new StyleElementBuilder(cssContent).type("text/css");
    }

    public static IHtmlDocument html5(CharSequence head, CharSequence body) {
        return new HtmlDocumentBuilder(HTML.head(head), HTML.body(body)).doctype();
    }

    public static IHtmlDocument html(CharSequence head, CharSequence body) {
        return new HtmlDocumentBuilder(HTML.head(head), HTML.body(body));
    }

    public static IHtmlContent plain(CharSequence ... text) {
        return new HtmlPlainBuilder(text);
    }

    public static IHtmlInput input() {
        return new HtmlInputBuilder();
    }
}

