/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.html.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.html.HTML;
import org.eclipse.scout.commons.html.HtmlBinds;
import org.eclipse.scout.commons.html.IHtmlContent;
import org.eclipse.scout.commons.html.internal.ReversedLengthComparator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public abstract class AbstractExpressionBuilder
implements CharSequence,
IHtmlContent {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractExpressionBuilder.class);
    private StringBuilder m_buf;
    private HtmlBinds m_binds = new HtmlBinds();

    protected StringBuilder validate() {
        if (this.m_buf == null) {
            this.m_buf = new StringBuilder();
            this.build();
        }
        return this.m_buf;
    }

    protected void invalidate() {
        this.m_buf = null;
    }

    protected abstract void build();

    @Override
    public int length() {
        return this.validate().length();
    }

    @Override
    public char charAt(int index) {
        return this.validate().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.validate().subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.validate().toString();
    }

    protected void append(CharSequence arg) {
        this.m_buf.append(arg);
    }

    @Override
    public HtmlBinds getBinds() {
        return this.m_binds;
    }

    @Override
    public void setBinds(HtmlBinds binds) {
        this.m_binds = binds;
    }

    protected IHtmlContent importHtml(IHtmlContent contentText) {
        HtmlBinds binds = contentText.getBinds();
        Map<String, String> replacements = this.getBinds().getReplacements(binds);
        if (!replacements.isEmpty()) {
            contentText.replaceBinds(replacements);
        }
        this.getBinds().putAll(contentText.getBinds());
        return contentText;
    }

    @Override
    public String toEncodedHtml() {
        String res = this.toString();
        List<String> binds = this.getBinds().getBindParameters(res);
        Collections.sort(binds, new ReversedLengthComparator());
        for (String b : binds) {
            Object value = this.getBinds().getBindValue(b);
            if (value == null) {
                LOG.error("No bind value found for ", b);
                continue;
            }
            String encode = this.encode(value);
            res = res.replaceAll(b, Matcher.quoteReplacement(encode));
        }
        return res;
    }

    @Override
    public String toPlainText() {
        IHtmlContent value = this;
        if (!StringUtility.contains(this.toString(), "body")) {
            value = HTML.body(this);
        }
        return HTMLUtility.getPlainText(value.toEncodedHtml());
    }

    protected String encode(Object value) {
        return StringUtility.htmlEncode(StringUtility.emptyIfNull(value).toString(), false);
    }

    @Override
    public void replaceBinds(Map<String, String> bindMap) {
        this.invalidate();
    }
}

