/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.transformation;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.rt.client.mobile.transformation.MobileDeviceTransformation;
import org.eclipse.scout.rt.client.mobile.transformation.MobileDeviceTransformer;
import org.eclipse.scout.rt.client.mobile.transformation.ToolFormHandler;
import org.eclipse.scout.rt.client.mobile.ui.desktop.MobileDesktopUtility;
import org.eclipse.scout.rt.client.mobile.ui.desktop.MultiPageChangeStrategy;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.IOutlineChooserForm;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.IPageForm;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IPageChangeStrategy;
import org.eclipse.scout.rt.client.ui.form.IForm;

public class TabletDeviceTransformer
extends MobileDeviceTransformer {
    private static int EAST_FORM_WIDTH = 700;

    public TabletDeviceTransformer() {
        this(null);
    }

    public TabletDeviceTransformer(IDesktop desktop) {
        super(desktop);
    }

    @Override
    protected void initTransformationConfig() {
        super.initTransformationConfig();
        this.getDeviceTransformationConfig().disableTransformation(MobileDeviceTransformation.MOVE_FIELD_LABEL_TO_TOP);
        this.getDeviceTransformationConfig().disableTransformation(MobileDeviceTransformation.ADD_MISSING_BACK_ACTION_TO_FORM_HEADER);
    }

    @Override
    public void adaptDesktopOutlines(Collection<IOutline> outlines) {
        MultiPageChangeStrategy strategy = new MultiPageChangeStrategy(this.getPageFormManager());
        for (IOutline outline : outlines) {
            outline.setPageChangeStrategy((IPageChangeStrategy)strategy);
        }
    }

    @Override
    protected ToolFormHandler createToolFormHandler(IDesktop desktop) {
        ToolFormHandler toolFormHandler = new ToolFormHandler(this.getDesktop());
        toolFormHandler.setCloseToolFormsAfterTablePageLoaded(false);
        return toolFormHandler;
    }

    @Override
    public List<String> getAcceptedViewIds() {
        LinkedList<String> viewIds = new LinkedList<String>();
        viewIds.add("C");
        viewIds.add("E");
        return viewIds;
    }

    @Override
    protected void transformView(IForm form) {
        boolean valueSet;
        if (!(form instanceof IPageForm) && !(form instanceof IOutlineChooserForm)) {
            form.setDisplayViewId("E");
        }
        if ("E".equals(form.getDisplayViewId()) && (valueSet = MobileDesktopUtility.setFormWidthHint(form, EAST_FORM_WIDTH))) {
            this.markGridDataDirty();
        }
    }
}

