/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.basic.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.IMobileTable;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.PagingTableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;

public class AbstractPagingSupport {
    private int m_pageSize;
    private int m_pageIndex;
    private int m_currentPageStartRowIndex;
    private IMobileTable m_table;
    private ITableRow m_nextElementsTableRow;
    private ITableRow m_previousElementsTableRow;

    public AbstractPagingSupport(IMobileTable table) {
        this.m_table = table;
        this.initProperties();
    }

    protected void initProperties() {
        this.setPageSize(this.m_table.getPageSize());
        this.setPageIndex(this.m_table.getPageIndex());
    }

    public List<ITableRow> getElementsOfCurrentPage(List<? extends ITableRow> rows) {
        this.initProperties();
        if (this.m_pageSize <= 0 || this.m_currentPageStartRowIndex < 0 || this.m_currentPageStartRowIndex >= rows.size()) {
            return CollectionUtility.arrayList(rows);
        }
        if (this.m_currentPageStartRowIndex == 0 && rows.size() < this.m_pageSize) {
            return CollectionUtility.arrayList(rows);
        }
        int currentPageEndRowIndex = Math.min(this.m_currentPageStartRowIndex + this.m_pageSize, rows.size()) - 1;
        int currentPageSize = currentPageEndRowIndex - this.m_currentPageStartRowIndex + 1;
        ArrayList<ITableRow> currentPage = new ArrayList<ITableRow>();
        int i = this.m_currentPageStartRowIndex;
        while (i <= currentPageEndRowIndex) {
            currentPage.add(rows.get(i));
            ++i;
        }
        if (this.m_currentPageStartRowIndex > 0) {
            this.m_previousElementsTableRow = this.createPreviousElementsTableRow();
            currentPage.add(0, this.m_previousElementsTableRow);
        }
        if (currentPageSize >= this.m_pageSize && this.m_currentPageStartRowIndex + this.m_pageSize < rows.size()) {
            this.m_nextElementsTableRow = this.createNextElementsTableRow();
            currentPage.add(this.m_nextElementsTableRow);
        }
        return currentPage;
    }

    protected ITableRow createPreviousElementsTableRow() {
        return new PagingTableRow(this.m_table.getColumnSet(), PagingTableRow.Type.back);
    }

    protected ITableRow createNextElementsTableRow() {
        return new PagingTableRow(this.m_table.getColumnSet(), PagingTableRow.Type.forward);
    }

    public int getCurrentPageStartRowIndex() {
        return this.m_currentPageStartRowIndex;
    }

    public int getPageIndex() {
        return this.m_pageIndex;
    }

    protected void setPageSize(int pageSize) {
        this.m_pageSize = pageSize;
        this.m_currentPageStartRowIndex = this.m_pageIndex * this.m_pageSize;
    }

    protected void setPageIndex(int pageIndex) {
        this.m_pageIndex = pageIndex;
        this.m_currentPageStartRowIndex = this.m_pageIndex * this.m_pageSize;
    }

    public int getPageSize() {
        return this.m_pageSize;
    }

    public ITableRow getPreviousElementsTableRow() {
        return this.m_previousElementsTableRow;
    }

    public ITableRow getNextElementsTableRow() {
        return this.m_nextElementsTableRow;
    }

    public IMobileTable getTable() {
        return this.m_table;
    }
}

