/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.search;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.services.common.search.ISearchFilterService;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.AbstractBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.composer.AbstractComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.internal.ComposerDisplayTextBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.AbstractHtmlField;
import org.eclipse.scout.rt.client.ui.form.fields.labelfield.AbstractLabelField;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.AbstractTreeBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.service.AbstractService;

public class DefaultSearchFilterService
extends AbstractService
implements ISearchFilterService {
    @Override
    public SearchFilter createNewSearchFilter() {
        return new SearchFilter();
    }

    @Override
    public void applySearchDelegate(IFormField field, SearchFilter search, boolean includeChildren) {
        AbstractValueField valueField;
        AbstractFormField range;
        String label = field.getLabel();
        if (field.getParentField() instanceof ISequenceBox && field.getParentField() instanceof AbstractFormField && (range = (AbstractFormField)((Object)field.getParentField())).getInitialLabel() != null) {
            label = String.valueOf(range.getInitialLabel()) + (StringUtility.isNullOrEmpty((String)label) ? "" : " " + label);
        }
        if (field instanceof AbstractComposerField) {
            AbstractComposerField composerField = (AbstractComposerField)field;
            ITreeNode rootNode = composerField.getTree().getRootNode();
            if (rootNode != null) {
                StringBuilder buf = new StringBuilder();
                new ComposerDisplayTextBuilder().build(rootNode, buf, "");
                String s = buf.toString();
                if (StringUtility.hasText((String)s)) {
                    search.addDisplayText(s);
                }
            }
            return;
        }
        if (field instanceof AbstractListBox) {
            valueField = (AbstractListBox)field;
            if (!((AbstractListBox)valueField).getValue().isEmpty()) {
                search.addDisplayText(String.valueOf(label) + " " + ScoutTexts.get((String)"LogicIn", (String[])new String[0]) + " " + valueField.getDisplayText());
            }
            return;
        }
        if (field instanceof AbstractTreeBox) {
            valueField = (AbstractTreeBox)field;
            if (!((AbstractTreeBox)valueField).getValue().isEmpty()) {
                search.addDisplayText(String.valueOf(label) + " " + ScoutTexts.get((String)"LogicIn", (String[])new String[0]) + " " + valueField.getDisplayText());
            }
            return;
        }
        if (field instanceof AbstractStringField || field instanceof AbstractHtmlField || field instanceof AbstractLabelField) {
            valueField = (AbstractValueField)field;
            if (valueField.getValue() != null) {
                search.addDisplayText(String.valueOf(label) + " " + ScoutTexts.get((String)"LogicLike", (String[])new String[0]) + " " + valueField.getDisplayText());
            }
            return;
        }
        if (field instanceof AbstractBooleanField) {
            valueField = (AbstractBooleanField)field;
            if (valueField.getValue() != null && ((Boolean)valueField.getValue()).booleanValue()) {
                search.addDisplayText(label);
            }
            return;
        }
        if (field instanceof AbstractRadioButtonGroup) {
            valueField = (AbstractRadioButtonGroup)field;
            if (valueField.getValue() != null) {
                IRadioButton selectedButton = ((AbstractRadioButtonGroup)valueField).getSelectedButton();
                search.addDisplayText(String.valueOf(label) + "=" + (selectedButton != null ? selectedButton.getLabel().replace("&", "") : ""));
            }
            return;
        }
        if (field instanceof AbstractValueField) {
            valueField = (AbstractValueField)field;
            if (valueField.getValue() != null) {
                search.addDisplayText(String.valueOf(label) + " " + ScoutTexts.get((String)"LogicEQ", (String[])new String[0]) + " " + valueField.getDisplayText());
            }
            return;
        }
        if (includeChildren) {
            this.applySearchDelegateForChildren(field, search);
        }
    }

    protected void applySearchDelegateForChildren(IFormField field, SearchFilter search) {
        if (field instanceof ICompositeField) {
            for (IFormField f : ((ICompositeField)field).getFields()) {
                f.applySearch(search);
            }
        }
    }
}

