/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.INumberColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberField;

@ClassId(value="6b77a24f-8685-4023-b353-cbbe7d4bf22a")
public abstract class AbstractNumberColumn<T extends Number>
extends AbstractColumn<T>
implements INumberColumn<T> {
    private boolean m_validateOnAnyKey;

    protected abstract T getConfiguredMinValue();

    protected abstract T getConfiguredMaxValue();

    @ConfigProperty(value="INTEGER")
    @Order(value=280.0)
    protected int getConfiguredMaxIntegerDigits() {
        return 32;
    }

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @Deprecated
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=150.0)
    protected boolean getConfiguredGroupingUsed() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    protected boolean getConfiguredValidateOnAnyKey() {
        return false;
    }

    @ConfigProperty(value="ROUNDING_MODE")
    @Order(value=170.0)
    protected RoundingMode getConfiguredRoundingMode() {
        return RoundingMode.UNNECESSARY;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.initFormat();
        this.setRoundingMode(this.getConfiguredRoundingMode());
        this.setGroupingUsed(this.getConfiguredGroupingUsed());
        if (this.getConfiguredFormat() != null) {
            ((DecimalFormat)this.propertySupport.getProperty("decimalFormat")).applyPattern(this.getConfiguredFormat());
        }
        this.setValidateOnAnyKey(this.getConfiguredValidateOnAnyKey());
        this.setMaxValue(this.getConfiguredMaxValue());
        this.setMinValue(this.getConfiguredMinValue());
    }

    protected void initFormat() {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getNumberInstance(LocaleThreadLocal.get());
        format.setParseBigDecimal(true);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(0);
        format.setMaximumIntegerDigits(this.getConfiguredMaxIntegerDigits());
        this.propertySupport.setProperty("decimalFormat", (Object)format);
    }

    @Override
    public void setFormat(DecimalFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("Format may not be null.");
        }
        DecimalFormat newFormat = (DecimalFormat)format.clone();
        newFormat.setParseBigDecimal(true);
        this.propertySupport.setProperty("decimalFormat", (Object)newFormat);
        this.validateColumnValues();
    }

    @Override
    public DecimalFormat getFormat() {
        return (DecimalFormat)((DecimalFormat)this.propertySupport.getProperty("decimalFormat")).clone();
    }

    @Deprecated
    protected final void setNumberFormat(NumberFormat fmt) {
        if (fmt instanceof DecimalFormat) {
            this.setFormat((DecimalFormat)fmt);
        }
        this.validateColumnValues();
    }

    @Override
    @Deprecated
    public NumberFormat getNumberFormat() {
        return this.getFormat();
    }

    @Override
    public void setMaxIntegerDigits(int maxIntegerDigits) {
        DecimalFormat format = this.getFormat();
        format.setMaximumIntegerDigits(maxIntegerDigits);
        this.setFormat(format);
    }

    @Override
    public int getMaxIntegerDigits() {
        return this.getFormatInternal().getMaximumIntegerDigits();
    }

    @Override
    public void setRoundingMode(RoundingMode roundingMode) {
        DecimalFormat format = this.getFormat();
        format.setRoundingMode(roundingMode);
        this.setFormat(format);
    }

    @Override
    public RoundingMode getRoundingMode() {
        return this.getFormatInternal().getRoundingMode();
    }

    protected DecimalFormat getFormatInternal() {
        return (DecimalFormat)this.propertySupport.getProperty("decimalFormat");
    }

    @Override
    public void setGroupingUsed(boolean b) {
        DecimalFormat format = this.getFormat();
        format.setGroupingUsed(b);
        this.setFormat(format);
    }

    @Override
    public boolean isGroupingUsed() {
        return this.getFormatInternal().isGroupingUsed();
    }

    @Override
    public void setMaxValue(T maxValue) {
        T min = this.getMinValue();
        if (maxValue != null && min != null && this.compareInternal(maxValue, min) < 0) {
            this.propertySupport.setProperty("minValue", maxValue);
        }
        this.propertySupport.setProperty("maxValue", maxValue);
        this.validateColumnValues();
    }

    @Override
    public T getMaxValue() {
        return (T)((Number)this.propertySupport.getProperty("maxValue"));
    }

    private int compareInternal(T a, T b) {
        return CompareUtility.compareTo((Comparable)NumberUtility.numberToBigDecimal(a), (Comparable)NumberUtility.numberToBigDecimal(b));
    }

    @Override
    public void setMinValue(T minValue) {
        T max = this.getMaxValue();
        if (minValue != null && max != null && this.compareInternal(minValue, max) > 0) {
            this.propertySupport.setProperty("maxValue", minValue);
        }
        this.propertySupport.setProperty("minValue", minValue);
        this.validateColumnValues();
    }

    @Override
    public T getMinValue() {
        return (T)((Number)this.propertySupport.getProperty("minValue"));
    }

    @Override
    public void setValidateOnAnyKey(boolean b) {
        this.m_validateOnAnyKey = b;
    }

    @Override
    public boolean isValidateOnAnyKey() {
        return this.m_validateOnAnyKey;
    }

    protected abstract INumberField<T> getEditorField();

    @Override
    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        INumberField<T> f = this.getEditorField();
        this.mapEditorFieldProperties(f);
        return f;
    }

    protected void mapEditorFieldProperties(INumberField<T> f) {
        super.mapEditorFieldProperties(f);
        f.setFormat(this.getFormat());
        f.setMinValue((Number)this.getMinValue());
        f.setMaxValue((Number)this.getMaxValue());
        f.setValidateOnAnyKey(this.isValidateOnAnyKey());
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        if (cell.getValue() != null) {
            cell.setText(this.getFormat().format(cell.getValue()));
        } else {
            cell.setText("");
        }
    }
}

