/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.numberfield;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractBasicField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberFieldUIFacade;
import org.eclipse.scout.rt.shared.ScoutTexts;

@ClassId(value="05955664-a6c7-4b3a-8622-3e166fe8ff79")
public abstract class AbstractNumberField<T extends Number>
extends AbstractBasicField<T>
implements INumberField<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractNumberField.class);
    private INumberFieldUIFacade m_uiFacade;

    public AbstractNumberField() {
        this(true);
    }

    public AbstractNumberField(boolean callInitializer) {
        super(callInitializer);
    }

    @Deprecated
    @Order(value=230.0)
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    protected boolean getConfiguredGroupingUsed() {
        return true;
    }

    @ConfigProperty(value="ROUNDING_MODE")
    @Order(value=250.0)
    protected RoundingMode getConfiguredRoundingMode() {
        return RoundingMode.UNNECESSARY;
    }

    protected abstract T getConfiguredMinValue();

    protected abstract T getConfiguredMaxValue();

    @ConfigProperty(value="INTEGER")
    @Order(value=280.0)
    protected int getConfiguredMaxIntegerDigits() {
        return 309;
    }

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.initFormat();
        this.setRoundingMode(this.getConfiguredRoundingMode());
        this.setGroupingUsed(this.getConfiguredGroupingUsed());
        if (this.getConfiguredFormat() != null) {
            this.getFormatInternal().applyPattern(this.getConfiguredFormat());
        }
        this.setMinValue(this.getConfiguredMinValue());
        this.setMaxValue(this.getConfiguredMaxValue());
    }

    protected void initFormat() {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getNumberInstance(LocaleThreadLocal.get());
        format.setParseBigDecimal(true);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(0);
        format.setMaximumIntegerDigits(this.getConfiguredMaxIntegerDigits());
        this.propertySupport.setProperty("decimalFormat", (Object)format);
    }

    @Override
    public void setRoundingMode(RoundingMode roundingMode) {
        try {
            DecimalFormat format = this.getFormat();
            format.setRoundingMode(roundingMode);
            this.setFormat(format);
            if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
                this.setDisplayText(this.execFormatValue((Number)this.getValue()));
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public RoundingMode getRoundingMode() {
        return this.getFormatInternal().getRoundingMode();
    }

    @Override
    public void setFormat(DecimalFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("Format may not be null.");
        }
        try {
            DecimalFormat newFormat = (DecimalFormat)format.clone();
            newFormat.setParseBigDecimal(true);
            this.propertySupport.setProperty("decimalFormat", (Object)newFormat);
            if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
                this.setDisplayText(this.execFormatValue((Number)this.getValue()));
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public DecimalFormat getFormat() {
        return (DecimalFormat)this.getFormatInternal().clone();
    }

    protected DecimalFormat getFormatInternal() {
        return (DecimalFormat)this.propertySupport.getProperty("decimalFormat");
    }

    @Override
    public void setGroupingUsed(boolean b) {
        try {
            DecimalFormat format = this.getFormat();
            format.setGroupingUsed(b);
            this.setFormat(format);
            if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
                this.setDisplayText(this.execFormatValue((Number)this.getValue()));
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public boolean isGroupingUsed() {
        return this.getFormatInternal().isGroupingUsed();
    }

    @Override
    public void setMaxIntegerDigits(int maxIntegerDigits) {
        try {
            DecimalFormat format = this.getFormat();
            format.setMaximumIntegerDigits(maxIntegerDigits);
            this.setFormat(format);
            if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
                this.setDisplayText(this.execFormatValue((Number)this.getValue()));
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getMaxIntegerDigits() {
        return this.getFormatInternal().getMaximumIntegerDigits();
    }

    @Override
    public void setMinValue(T value) {
        T n = value == null ? this.getMinPossibleValue() : value;
        try {
            this.setFieldChanging(true);
            T max = this.getMaxValue();
            if (n != null && max != null && this.compareInternal(n, max) > 0) {
                this.propertySupport.setProperty("maxValue", n);
            }
            this.propertySupport.setProperty("minValue", n);
            if (this.isInitialized()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public T getMinValue() {
        return (T)((Number)this.propertySupport.getProperty("minValue"));
    }

    @Override
    public void setMaxValue(T value) {
        T n = value == null ? this.getMaxPossibleValue() : value;
        try {
            this.setFieldChanging(true);
            T min = this.getMinValue();
            if (n != null && min != null && this.compareInternal(n, min) < 0) {
                this.propertySupport.setProperty("minValue", n);
            }
            this.propertySupport.setProperty("maxValue", n);
            if (this.isInitialized()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public T getMaxValue() {
        return (T)((Number)this.propertySupport.getProperty("maxValue"));
    }

    private int compareInternal(T a, T b) {
        return CompareUtility.compareTo((Comparable)NumberUtility.numberToBigDecimal(a), (Comparable)NumberUtility.numberToBigDecimal(b));
    }

    protected abstract T getMinPossibleValue();

    protected abstract T getMaxPossibleValue();

    @Override
    protected T validateValueInternal(T rawValue) throws ProcessingException {
        T validValue = null;
        if ((rawValue = (Number)super.validateValueInternal(rawValue)) == null) {
            validValue = null;
        } else {
            if (this.getMaxValue() != null && this.compareInternal(rawValue, this.getMaxValue()) > 0) {
                this.throwNumberTooLarge();
            }
            if (this.getMinValue() != null && this.compareInternal(rawValue, this.getMinValue()) < 0) {
                this.throwNumberTooSmall();
            }
            validValue = rawValue;
        }
        return validValue;
    }

    @Override
    protected String formatValueInternal(T validValue) {
        if (validValue == null) {
            return "";
        }
        String displayValue = this.getFormatInternal().format(validValue);
        return displayValue;
    }

    @Deprecated
    protected NumberFormat createNumberFormat() {
        return this.getFormat();
    }

    @Override
    public INumberFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected abstract T parseValueInternal(String var1) throws ProcessingException;

    protected BigDecimal parseToBigDecimalInternal(String text) throws ProcessingException {
        BigDecimal retVal = null;
        if ((text = text == null ? "" : text.trim()).length() > 0) {
            text = this.ensureSuffix(text);
            ParsePosition p = new ParsePosition(0);
            BigDecimal valBeforeRounding = (BigDecimal)this.getFormatInternal().parse(text, p);
            if (p.getErrorIndex() >= 0 || p.getIndex() != text.length()) {
                throw new ProcessingException(ScoutTexts.get((String)"InvalidNumberMessageX", (String[])new String[]{text}));
            }
            try {
                retVal = this.roundParsedValue(valBeforeRounding);
            }
            catch (ArithmeticException e) {
                throw new ProcessingException(ScoutTexts.get((String)"InvalidNumberMessageX", (String[])new String[]{text}));
            }
            if (this.getMinValue() != null && retVal.compareTo(NumberUtility.numberToBigDecimal(this.getMinValue())) < 0) {
                this.throwNumberTooSmall();
            }
            if (this.getMaxValue() != null && retVal.compareTo(NumberUtility.numberToBigDecimal(this.getMaxValue())) > 0) {
                this.throwNumberTooLarge();
            }
        }
        return retVal;
    }

    private void throwNumberTooLarge() throws VetoException {
        if (this.getMinValue() == null || CompareUtility.equals(this.getMinValue(), this.getMinPossibleValue())) {
            throw new VetoException(ScoutTexts.get((String)"NumberTooLargeMessageX", (String[])new String[]{this.formatValueInternal(this.getMaxValue())}));
        }
        throw new VetoException(ScoutTexts.get((String)"NumberTooLargeMessageXY", (String[])new String[]{this.formatValueInternal(this.getMinValue()), this.formatValueInternal(this.getMaxValue())}));
    }

    private void throwNumberTooSmall() throws VetoException {
        if (this.getMaxValue() == null || CompareUtility.equals(this.getMaxValue(), this.getMaxPossibleValue())) {
            throw new VetoException(ScoutTexts.get((String)"NumberTooSmallMessageX", (String[])new String[]{this.formatValueInternal(this.getMinValue())}));
        }
        throw new VetoException(ScoutTexts.get((String)"NumberTooSmallMessageXY", (String[])new String[]{this.formatValueInternal(this.getMinValue()), this.formatValueInternal(this.getMaxValue())}));
    }

    protected BigDecimal roundParsedValue(BigDecimal valBeforeRounding) {
        int precision = valBeforeRounding.toBigInteger().toString().length();
        return valBeforeRounding.round(new MathContext(precision, this.getRoundingMode()));
    }

    private String ensureSuffix(String text) {
        String negativeSuffix;
        String positiveSuffix = this.getFormatInternal().getPositiveSuffix();
        if (positiveSuffix.equals(negativeSuffix = this.getFormatInternal().getNegativeSuffix())) {
            String trimmedSuffix = StringUtility.trim((String)positiveSuffix);
            if (text.endsWith(trimmedSuffix)) {
                text = StringUtility.trim((String)text.substring(0, text.length() - trimmedSuffix.length()));
            }
            text = StringUtility.concatenateTokens((String[])new String[]{text, positiveSuffix});
        }
        return text;
    }

    public static boolean isWithinNumberFormatLimits(DecimalFormat format, String curText, int offset, int replaceLen, String insertText) {
        if (insertText == null || insertText.length() < 1) {
            return true;
        }
        String futureText = null;
        if (curText == null) {
            futureText = insertText;
        } else {
            StringBuilder docTxt = new StringBuilder(curText.length() + insertText.length());
            docTxt.append(curText);
            docTxt.replace(offset, offset + replaceLen, insertText);
            futureText = docTxt.toString();
        }
        Pattern pat = Pattern.compile("[^1-9" + format.getDecimalFormatSymbols().getZeroDigit() + "]");
        String decimalSeparator = String.valueOf(format.getDecimalFormatSymbols().getDecimalSeparator());
        String[] parts = futureText.split(Pattern.quote(decimalSeparator));
        if (parts.length >= 1) {
            boolean intPartValid;
            String intPartDigits = pat.matcher(parts[0]).replaceAll("");
            boolean bl = intPartValid = StringUtility.length((String)intPartDigits) <= format.getMaximumIntegerDigits();
            if (!intPartValid) {
                return false;
            }
        }
        if (parts.length == 2) {
            boolean fracPartValid;
            String fracPartDigits = pat.matcher(parts[1]).replaceAll("");
            boolean bl = fracPartValid = StringUtility.length((String)fracPartDigits) <= format.getMaximumFractionDigits();
            if (!fracPartValid) {
                return false;
            }
        }
        return true;
    }

    public static String createNumberWithinFormatLimits(DecimalFormat format, String curText, int offset, int replaceLen, String insertText) throws ProcessingException {
        if (insertText == null || insertText.length() < 1) {
            insertText = "";
        }
        StringBuilder result = new StringBuilder();
        String futureText = null;
        if (curText == null) {
            futureText = insertText;
        } else {
            StringBuilder docTxt = new StringBuilder(curText.length() + insertText.length());
            docTxt.append(curText);
            docTxt.replace(offset, offset + replaceLen, insertText);
            futureText = docTxt.toString();
        }
        Pattern pat = Pattern.compile("[^1-9" + format.getDecimalFormatSymbols().getZeroDigit() + "]");
        String decimalSeparator = String.valueOf(format.getDecimalFormatSymbols().getDecimalSeparator());
        String[] parts = futureText.split(Pattern.quote(decimalSeparator));
        if (parts.length >= 1) {
            boolean intPartValid;
            String intPartDigits = pat.matcher(parts[0]).replaceAll("");
            boolean bl = intPartValid = StringUtility.length((String)intPartDigits) <= format.getMaximumIntegerDigits();
            if (intPartValid) {
                result.append(intPartDigits);
            } else {
                throw new ProcessingException("Do not truncate integer digits!");
            }
        }
        if (parts.length == 2) {
            boolean fracPartValid;
            String fracPartDigits = pat.matcher(parts[1]).replaceAll("");
            boolean bl = fracPartValid = StringUtility.length((String)fracPartDigits) <= format.getMaximumFractionDigits();
            if (fracPartValid) {
                result.append(String.valueOf(decimalSeparator) + fracPartDigits);
            } else {
                result.append(String.valueOf(decimalSeparator) + fracPartDigits.substring(0, format.getMaximumFractionDigits()));
            }
        }
        return result.toString();
    }

    private class P_UIFacade
    implements INumberFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setTextFromUI(String newText, boolean whileTyping) {
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            AbstractNumberField.this.setWhileTyping(whileTyping);
            return AbstractNumberField.this.parseValue(newText);
        }
    }
}

