/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.plannerfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.activitymap.AbstractActivityMap;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityCell;
import org.eclipse.scout.rt.client.ui.basic.activitymap.IActivityMap;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.plannerfield.IPlannerField;
import org.eclipse.scout.rt.client.ui.form.fields.plannerfield.IPlannerFieldUIFacade;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="8fbfbf19-ff9d-4e89-8a78-8e6a4a8dc36c")
public abstract class AbstractPlannerField<T extends ITable, P extends IActivityMap<RI, AI>, RI, AI>
extends AbstractFormField
implements IPlannerField<T, P, RI, AI> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractPlannerField.class);
    private IPlannerFieldUIFacade m_uiFacade;
    private T m_resourceTable;
    private IColumn<RI> m_resourceIdColumn;
    private P m_activityMap;
    private boolean m_selectionMediatorRunning;

    public AbstractPlannerField() {
        this(true);
    }

    public AbstractPlannerField(boolean callInitializer) {
        super(callInitializer);
    }

    private Class<? extends ITable> getConfiguredResourceTable() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClass((Class[])dca, ITable.class);
    }

    private Class<? extends IActivityMap> getConfiguredActivityMap() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClass((Class[])dca, IActivityMap.class);
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=10.0)
    protected int getConfiguredMiniCalendarCount() {
        return 2;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=20.0)
    protected int getConfiguredSplitterPosition() {
        return 168;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) throws ProcessingException {
        this.loadResourceTableData();
    }

    @ConfigOperation
    @Order(value=10.0)
    protected Object[][] execLoadResourceTableData() throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execPopulateResourceTable() throws ProcessingException {
        Object[][] data = this.execLoadResourceTableData();
        this.getResourceTable().replaceRowsByMatrix(data);
    }

    @ConfigOperation
    @Order(value=10.0)
    protected Object[][] execLoadActivityMapData(List<? extends RI> resourceIds, List<? extends ITableRow> resourceRows) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execPopulateActivities(List<RI> resourceIds, List<ITableRow> resourceRows) throws ProcessingException {
        Object[][] data = this.execLoadActivityMapData(resourceIds, resourceRows);
        ArrayList list = new ArrayList();
        Object[][] objectArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] row = objectArray[n2];
            ActivityCell cell = new ActivityCell(row);
            list.add(cell);
            ++n2;
        }
        this.getActivityMap().removeActivityCellsById(resourceIds);
        this.getActivityMap().addActivityCells(list);
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_PlannerFieldUIFacade();
        super.initConfig();
        this.setMiniCalendarCount(this.getConfiguredMiniCalendarCount());
        this.setSplitterPosition(this.getConfiguredSplitterPosition());
        if (this.getConfiguredResourceTable() != null) {
            try {
                this.m_resourceTable = (ITable)ConfigurationUtility.newInnerInstance((Object)this, this.getConfiguredResourceTable());
                if (this.m_resourceTable instanceof AbstractTable) {
                    ((AbstractTable)this.m_resourceTable).setContainerInternal(this);
                }
                this.m_resourceTable.setEnabled(this.isEnabled());
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + this.getConfiguredResourceTable().getName() + "'.", (Throwable)e));
            }
            Iterator<IColumn<?>> iterator = this.getResourceTable().getColumnSet().getKeyColumns().iterator();
            if (iterator.hasNext()) {
                IColumn<?> c = iterator.next();
                this.m_resourceIdColumn = c;
            }
        } else {
            LOG.warn("there is no inner class of type ITable in " + this.getClass());
        }
        if (this.getConfiguredActivityMap() != null) {
            try {
                this.m_activityMap = (IActivityMap)ConfigurationUtility.newInnerInstance((Object)this, this.getConfiguredActivityMap());
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + this.getConfiguredActivityMap().getName() + "'.", (Throwable)e));
            }
            if (this.m_activityMap instanceof AbstractActivityMap) {
                ((AbstractActivityMap)this.m_activityMap).setContainerInternal(this);
            }
        } else {
            LOG.warn("there is no inner class of type IActivityMap in " + this.getClass());
        }
        this.m_resourceTable.addTableListener(new P_ResourceTableListener());
        this.m_activityMap.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("selectedResourceIds")) {
                    AbstractPlannerField.this.syncSelectionFromActivityToResource();
                }
            }
        });
    }

    private IColumn<RI> getResourceIdColumnInternal() {
        return this.m_resourceIdColumn;
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        this.getResourceTable().initTable();
        this.getActivityMap().initActivityMap();
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        this.getResourceTable().disposeTable();
        this.getActivityMap().disposeActivityMap();
    }

    @Override
    public int getMiniCalendarCount() {
        return this.propertySupport.getPropertyInt("miniCalendarCount");
    }

    @Override
    public void setMiniCalendarCount(int n) {
        if (n < 0 || n > 6) {
            return;
        }
        this.propertySupport.setPropertyInt("miniCalendarCount", n);
    }

    @Override
    public int getSplitterPosition() {
        return this.propertySupport.getPropertyInt("splitterPosition");
    }

    @Override
    public void setSplitterPosition(int splitterPosition) {
        this.propertySupport.setPropertyInt("splitterPosition", splitterPosition);
    }

    @Override
    public final T getResourceTable() {
        return this.m_resourceTable;
    }

    @Override
    public final P getActivityMap() {
        return this.m_activityMap;
    }

    @Override
    public void loadResourceTableData() throws ProcessingException {
        this.execPopulateResourceTable();
    }

    @Override
    public void loadActivityMapData() throws ProcessingException {
        this.loadActivityMapDataInternal(this.getResourceTable().getRows());
    }

    @Override
    public void loadActivityMapDataOfSelectedRecources() throws ProcessingException {
        this.loadActivityMapDataInternal(this.getResourceTable().getSelectedRows());
    }

    private void loadActivityMapDataInternal(List<? extends ITableRow> resourceRows) throws ProcessingException {
        List<RI> resourceIds = this.getResourceIdColumnInternal().getValues(resourceRows);
        try {
            this.getActivityMap().setActivityMapChanging(true);
            this.execPopulateActivities(CollectionUtility.arrayList(resourceIds), CollectionUtility.arrayList(resourceRows));
        }
        finally {
            this.getActivityMap().setActivityMapChanging(false);
        }
    }

    @Override
    public ITableRow activityCellToResourceRow(ActivityCell<RI, AI> activityCell) {
        if (activityCell != null) {
            return this.getResourceIdColumnInternal().findRow(activityCell.getResourceId());
        }
        return null;
    }

    @Override
    public List<ITableRow> activityCellsToResourceRows(List<? extends ActivityCell<RI, AI>> activityCells) {
        ArrayList<ITableRow> resourceRowSet = new ArrayList<ITableRow>(activityCells.size());
        for (ActivityCell<RI, AI> cell : activityCells) {
            ITableRow resourceRow = this.getResourceIdColumnInternal().findRow(cell.getResourceId());
            if (resourceRow == null) continue;
            resourceRowSet.add(resourceRow);
        }
        return resourceRowSet;
    }

    @Override
    public List<ActivityCell<RI, AI>> resourceRowToActivityCells(ITableRow resourceRow) {
        return this.resourceRowsToActivityCells(CollectionUtility.arrayList((Object)resourceRow));
    }

    @Override
    public List<ActivityCell<RI, AI>> resourceRowsToActivityCells(List<? extends ITableRow> resourceRows) {
        return this.getActivityMap().getActivityCells(this.getResourceIdColumnInternal().getValues(resourceRows));
    }

    private void syncSelectionFromResourceToActivity() {
        if (this.m_selectionMediatorRunning) {
            return;
        }
        try {
            this.m_selectionMediatorRunning = true;
            this.getActivityMap().setSelectedResourceIds(this.getResourceIdColumnInternal().getSelectedValues());
        }
        finally {
            this.m_selectionMediatorRunning = false;
        }
    }

    private void syncSelectionFromActivityToResource() {
        if (this.m_selectionMediatorRunning) {
            return;
        }
        try {
            this.m_selectionMediatorRunning = true;
            List<ITableRow> resourceRows = this.getResourceIdColumnInternal().findRows((RI)this.getActivityMap().getSelectedResourceIds());
            this.getResourceTable().selectRows(resourceRows, false);
        }
        finally {
            this.m_selectionMediatorRunning = false;
        }
    }

    @Override
    public IPlannerFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private class P_PlannerFieldUIFacade
    implements IPlannerFieldUIFacade {
        private P_PlannerFieldUIFacade() {
        }

        @Override
        public void refreshFromUI() {
            try {
                AbstractPlannerField.this.loadResourceTableData();
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }

        @Override
        public void setSplitterPositionFromUI(Integer value) {
            AbstractPlannerField.this.propertySupport.setPropertyNoFire("splitterPosition", (Object)value);
        }
    }

    private class P_ResourceTableListener
    extends TableAdapter {
        private P_ResourceTableListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            switch (e.getType()) {
                case 100: 
                case 102: 
                case 105: 
                case 200: 
                case 210: {
                    AbstractPlannerField.this.m_activityMap.setResourceIds(AbstractPlannerField.this.getResourceIdColumnInternal().getValues(AbstractPlannerField.this.getResourceTable().getFilteredRows()));
                }
            }
            switch (e.getType()) {
                case 210: {
                    try {
                        AbstractPlannerField.this.loadActivityMapDataInternal(AbstractPlannerField.this.getResourceTable().getFilteredRows());
                    }
                    catch (ProcessingException ex) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                    }
                }
                case 100: {
                    try {
                        AbstractPlannerField.this.loadActivityMapDataInternal(e.getRows());
                    }
                    catch (ProcessingException ex) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                    }
                    break;
                }
                case 101: {
                    try {
                        AbstractPlannerField.this.loadActivityMapDataInternal(e.getRows());
                    }
                    catch (ProcessingException ex) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                    }
                    break;
                }
                case 103: {
                    AbstractPlannerField.this.syncSelectionFromResourceToActivity();
                }
            }
        }
    }
}

