/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.splitbox.internal;

import java.util.ArrayList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;

public class SplitBoxGrid {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SplitBoxGrid.class);
    private ISplitBox m_splitBox = null;
    private IFormField[] m_fields;
    private int m_gridColumns;
    private int m_gridRows;

    public SplitBoxGrid(ISplitBox splitBox) {
        this.m_splitBox = splitBox;
    }

    public void validate() {
        this.m_gridColumns = 2;
        this.m_gridRows = 1;
        ArrayList<IFormField> list = new ArrayList<IFormField>();
        for (IFormField f : this.m_splitBox.getFields()) {
            if (f.isVisible()) {
                list.add(f);
                continue;
            }
            GridData data = GridDataBuilder.createFromHints(f, 1);
            f.setGridDataInternal(data);
        }
        this.m_fields = list.toArray(new IFormField[list.size()]);
        this.layoutStatic();
    }

    private void layoutStatic() {
        int x = 0;
        int i = 0;
        while (i < this.m_fields.length) {
            GridData data = GridDataBuilder.createFromHints(this.m_fields[i], 1);
            data.x = x;
            data.y = 0;
            if (data.weightX < 0.0) {
                data.weightX = data.w;
            }
            this.m_fields[i].setGridDataInternal(data);
            x += data.w;
            this.m_gridRows = Math.max(this.m_gridRows, data.h);
            ++i;
        }
        this.m_gridColumns = x;
    }

    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    public int getGridRowCount() {
        return this.m_gridRows;
    }
}

